;******************************************************
;tb_survey_pos_2008.pro <-- tb_tau_rh_pos_asy2005.pro
;******************************************************
;30/11/07 <-- 160403
;display pos-plots vs. tau and rh



program0='tb_survey_pos_2008'
ps=-1
psdirect,def=999    ;remove defaults



sc=1.3
sc=1.5
nx=100*sc
ny=100*sc
n99=nx-1
n98=nx-1

dire='TB_SURVEY_POS/'


icasemax=5
col1=1
for idump=0,1 do begin

;idump=0 -> make the image
   if(idump eq 0) then begin
      nwin,xs=1100*sc,ys=700*sc,/pix
      apu=fltarr(1100*sc,700*sc)
      tv,apu*0
   endif

;idump=1 -> print to ps with labels
   if(idump eq 1) then begin
      psdirect,program0,ps,xsize=24,ysize=24.*ny/nx
      nwin,xs=nx,ys=ny
      tvscl,255-ima
   endif

for icase=0,icasemax-1 do begin

    print,'----------------------------------------------'
    istart=(icase+1)*11+1
    dxpos=0.


;sirius: tbgrav120tau090_2007   EST=280Ksec/25orb
;taygeta:

;--------------
;tau=1.8
;--------------
    if(icase eq 0) then begin
       files=dire+'tbgrav'+ ['060tau180.pos28','070tau180.pos','080tau180_2007.pos','090tau180_2007.pos','100tau180_2007.pos']    
       rhot=fltarr(n_elements(files))+900.
       dxpos=0. 
       eps5=rhot*0+.5
    endif
;--------------
;    tau=1.4
;--------------
    if(icase eq 1) then begin
       files=dire+'tbgrav'+ ['060tau140.pos','070tau140.pos','080tau140_128.pos','090tau140.pos','100tau140.pos','110tau140_2007.pos']    
       rhot=fltarr(n_elements(files))+900.
       dxpos=0. 
       eps5=rhot*0+.5  
    endif
;--------------
;    tau=0.9
;--------------
    if(icase eq 2) then begin
       files=dire+'tbgrav'+ ['060tau090.pos','070tau090.pos','080tau090.pos','090tau090.pos','100tau090.pos','110tau090.pos','120tau090_2007.pos']
         rhot=fltarr(n_elements(files))+900.
       dxpos=0. 
       eps5=rhot*0+.5  
    endif
;--------------
;    tau=0.5
;--------------
    if(icase eq 3) then begin
        files=dire+'tbgrav'+['060','070','080','090','100','110','120','130','140','150']+'tau050.pos'
        rhot=fltarr(n_elements(files))+900.
        eps5=rhot*0+.5
        dxpos=0. 
    endif

;--------------
;    tau=0.25
;--------------
    if(icase eq 4) then begin
        files=dire+'tbgrav'+['060','070','080','090','100','110','120','130','140','150']+'tau025.pos'
        rhot=fltarr(n_elements(files))+900.
        eps5=rhot*0+.5
        dxpos=0.
    endif

    nfiles=n_elements(files)
    imin=0
    if(icase eq 5) then imin=4
    if(icase eq 4) then imin=2

    for i=imin,nfiles-1 do begin
        close,1
        openr,1,files(i),err=stat
        if(stat ne 0) then begin
           print,files(i),' not found'
           dens=fltarr(nx,ny)
           dens(0,*)=10
           dens(1,*)=10
           dens(n99,*)=10
           dens(n98,*)=10
           dens(*,0)=10
           dens(*,1)=10
           dens(*,n99)=10
            dens(*,n98)=10
            tvscl,dens<2,i+istart 
            goto,nofile
        endif


        restore,files(i)
        rp,rhot(i),eta,1.,rp,rh=rh,/nopr,lcr=lcr
        lcr_true=lcr*taumin*ss(0)
        print,files(i),orb,xl,xl/lcr_true,yl/lcr_true,rh,format='(a50,f6.2,4f8.2)'
        xl_use=2.*lcr_true
        yl_use=xl_use

;        xl_use=xl
;        yl_use=yl


        if(idump eq 1) then begin

           chars=1.9*sc
           if(!d.name eq 'PS') then chars=0.8 
           xyouts,(20.*sc)/nx,(550.-icase*100)*sc/ny,string(taumin,'(f6.2)'),/nor,chars=chars,chart=1,col=col1
           IF(ICASE EQ 3 or icase eq 4) THEN  begin
              xyouts,(i+1.5)*100*sc/nx,(icasemax*100+150)*sc/ny,ali=.5,string(rh,'(f6.2)'),/nor,chars=chars,charthick=1,col=col1
              xyouts,(i+1.5)*100*sc/nx,(icasemax*100+120)*sc/ny,ali=.5,string(long(eta),'(i6)'),/nor,$
                     chars=chars,charthick=1,col=col1
           endif
        endif


        yy_use=yy

        if(idump eq 0) then begin
        xy_to_dens3,xx+dxpos,yy_use,100*sc,100*sc,xl_use,yl_use,dens,/nop,/nor,sil=3
        dens(0,0)=10.
        dens(1,1)=0.0
        dens(0,*)=10
        dens(1,*)=10
        dens(n99,*)=10
        dens(n98,*)=10

        dens(*,0)=10
        dens(*,1)=10
        dens(*,n99)=10
        dens(*,n98)=10
        tvscl,dens<2,i+istart

        xpos_use=(i mod 10)*100*sc+100*Sc
        ypos_use=((5-icase)*100+6)*sc
        endif

nofile:

 endfor


    if(idump eq 0) then begin
       ima=tvrd(0,0)
       nx=n_elements(ima(*,0))
       ny=n_elements(ima(0,*))
    endif

    if(idump eq 1) then begin

       chars=1.9*sc
       if(!d.name eq 'PS') then chars=0.8 

       plots,[0,100]*Sc*1./nx,[100*icasemax+200,100*icasemax+100]*sc*1./ny,/nor,thick=3
       xyouts,80*sc*1./nx,(sc*icasemax*100+150*sc)*1./ny,/nor,textoidl('r_h'),chars=chars,charthick=1
       xyouts,80*sc*1./nx,(sc*icasemax*100+120*sc)*1./ny,/nor,textoidl(' a'),chars=chars,charthick=1
       xyouts,20*sc*1./nx,(sc*icasemax*100+120*sc)*1./ny,/nor,textoidl('\tau'),chars=chars,charthick=1       
       xyouts,100.*sc/nx,60.*sc/ny,'constant coefficient of restitution 0.5',/nor,chars=chars*1.2,chart=1
       xyouts,100.*Sc/nx,25.*Sc/ny,'identical particles',/nor,chars=chars*1.2,charth=1

    endif

endfor

if(idump eq 1) then begin
   psdirect,program0,ps,xsize=24,ysize=24.*ny/nx,/stop
endif

vast=''
;read,vast



endfor


end

