;tb_hconditions.pro
program='tb_hconditions'
ps=1
psdirect,program,ps

chars=1.25
q=2.
;!p.multi=[0,2,1]
nwin
for icase=1,1 do begin
plot,lindgen(10),lindgen(10),xr=[0.4,1.4],yr=[0,1.],xs=1,ys=1,xtitle=textoidl('r_h'),ytitle=textoidl('\tau'),/nod,chars=chars,xticklen=-0.02,yticklen=-0.02

rh=(findgen(200)+1)/200.*1.+0.4<1.2


tau=(findgen(100)+1)/100.*1

if(icase eq 1) then HIMP=6.
if(icase eq 2) then HIMP=12.

nh=n_elements(rh)
nt=n_elements(tau)
rhtab=fltarr(nh,nt)
tautab=fltarr(nh,nt)
for i=0,nh-1 do begin
    for j=0,nt-1 do begin
        rhtab(i,j)=rh(i)
        tautab(i,j)=tau(j)
    endfor
endfor
hwake=25*q*tautab*rhtab^3
henc=2*sqrt(24.)*rhtab^1.5
hcoll=tautab*0.+himp



h=hwake>henc
h=h>hcoll

contour,h,rhtab,tautab,/noerase,/over,lev=[10,20,30,40,50]*1.,c_lines=2,thick=1

;wakes
oplot,rh,himp/25./q/rh^3,col=3,thick=3
;encounters
apux=(himp/(2.*sqrt(24.)))^(2./3.)
apuy=himp/25./q/apux^3


;---------------------------------
;fill
;---------------------------------



;wakes
xarg=rh
yarg1=himp/25./q/xarg^3<1.>2*sqrt(24.)/xarg^1.5/25./q
yarg2=yarg1*0.+1.
plot_fill,xarg,yarg1,yarg2,style=1
xx=[xarg,reverse(xarg)]
yy=[yarg1,reverse(yarg2)]
polyfill,xx,yy,col=140

;impacts
xarg=rh(where(rh le apux))
yarg2=himp/25./q/xarg^3<1.
yarg1=yarg2*0.
;plot_fill,xarg,yarg1,yarg2,style=1
xx=[xarg,reverse(xarg)]
yy=[yarg1,reverse(yarg2)]
;polyfill,xx,yy,col=100,/line_fill,spac=.75

;encounters
xarg=rh(where(rh ge apux*.992))
yarg2=himp/25./q/xarg^3
yarg2=2*sqrt(24.)/xarg^1.5/25./q
yarg1=yarg2*0.
xx=[xarg,reverse(xarg)]
yy=[yarg1,reverse(yarg2)]
polyfill,xx,yy,col=200

;aggregates
xarg=1.2+findgen(21)/20.*.2
yarg2=xarg*0.+1.
yarg1=yarg2*0.
xx=[xarg,reverse(xarg)]
yy=[yarg1,reverse(yarg2)]
polyfill,xx,yy,col=100;,/line_fill,spac=.75

contour,h,rhtab,tautab,/noerase,/over,lev=[10,20,30,40,50]*1.,c_lines=2,thick=1


oplot,(himp/(2.*sqrt(24.)))^(2./3.)*[1,1],[0,apuy],col=2,thick=3
oplot,[1.2,1.2],[0,2],lines=1,col=5,thick=3

xyouts,0.75,.05,'ENCOUNTERS',col=1,charthick=1,chars=chars
xyouts,0.45,.23,'IMPACTS',col=1,chars=chars
xyouts,0.7,.6,'WAKES',chars=chars,col=255,charthick=2
xyouts,1.3,.4,'AGGREGATES',ori=90,chars=chars,col=255,charthick=2

xyouts,0.45,1.025,'OVERSTABILITY',col=1,ori=0,chars=chars


;xyouts,1.0,0.21,'10',chars=chars*.7
;xyouts,1.0,0.42,'20',chars=chars*.7
;xyouts,1.0,0.63,'30',chars=chars*.7
;xyouts,1.0,0.82,'40',chars=chars*.7

xyouts,0.85,0.33,'10',chars=chars*.7
xyouts,0.93,0.51,'20',chars=chars*.7
xyouts,1.0,0.63,'30',chars=chars*.7
xyouts,1.05,0.71,'40',chars=chars*.7
xyouts,1.1,0.79,'50',chars=chars*.7


;oplot,rh,2*sqrt(24.)/rh^1.5/25./q

endfor
!p.multi=0
psdirect,program,ps,/vfont,/stop
end
