;dpsplot_epspos.pro
;compares position files at A=100

program='gg2008_epspos'
ps=-1

;restore,'ikiturso_nr450a130n4_100_hatzes/*.pos
;sidetop_xyz,xx,yy,zz,ss,xl,light=1,file='ikiturso_nr450a130n4_100_hatzes.pos',/w800

;restore,'ikiturso_nr450a130n4_100_bridges/*.pos
;sidetop_xyz,xx,yy,zz,ss,xl,light=1,file='ikiturso_nr450a130n4_100_bridges.pos',/w800

runid1='ikiturso_nr450a130n4_100_bridges.possidetop'
runid2='ikiturso_nr450a130n4_100_hatzes.possidetop'

fac=2
n50=50*fac
n350=350*fac
n150=150*fac
n250=250*fac
n690=300*2*fac+90
n550=510*fac+40
nwin,xs=n690,ys=n550,/pix

dy=40
restore,runid1
tvscl,imagetop(n50:n350,n50:n350),40,130*fac+dy

restore,runid2
tvscl,imagetop(n50:n350,n50:n350),300*fac+50,130*fac+dy

restore,runid1
tvscl,imageside(n50:n350,n150:n250),40,0+dy

restore,runid2
tvscl,imageside(n50:n350,n150:n250),300*fac+50,00+dy


ima=tvrd(0,0)
nx=n_elements(ima(*,0))
ny=n_elements(ima(0,*))

psdirect,program,ps,/color,xsize=16,ysize=16.*ny/nx
nwin,xs=nx,ys=ny
tvscl,255-ima

c255=0
xyouts,/normal,0.25,0.9,ali=0.5,'BRIDGES-ELASTICITY MODEL',charsize=1.,charthick=1,col=c255
xyouts,/normal,0.75,0.9,ali=0.5,'HATZES-ELASTICITY MODEL',charsize=1.,charthick=1,col=c255



dy=0.075*nx/ny
dx=0.075

arrow,0.034,0.28,0.034+dx,0.28,thick=1.75,/normal,col=c255
arrow,0.034,0.28,0.034,0.28+dy,thick=1.75,/normal,col=c255

arrow,0.034,0.08,0.034+dx,0.08,thick=1.75,/normal,col=c255
arrow,0.034,0.08,0.034,0.08+dy,thick=1.75,/normal,col=c255

xyouts,0.034+dx*1.1,0.28-0.009,'X',/nor,charthick=1.75,charsize=1.,col=c255
xyouts,0.034-0.009,0.28+1.1*dy,'Y',/nor,charthick=1.75,charsize=1.,col=c255

xyouts,0.034+dx*1.1,0.08-0.009,'X',/nor,charthick=1.75,charsize=1.,col=c255
xyouts,0.034-0.009,0.08+1.1*dy,'Z',/nor,charthick=1.75,charsize=1.,col=c255

psdirect,program,ps,/stop



end




