;---------------------------------------------------
program='cassini_hsfig1'  & ps=0
;---------------------------------------------------
;compare bridges/hatzes  epn(v)
;compare                 thickness & dynamic viscosity
;---------------------------------------------------
psdirect,program+'_1',ps,/color,xsize=18

  col1=1
  if(!d.name eq 'PS') then col1=0

  c8=0.8
  cplot=1
  v=findgen(200)/100.+0.005	;velocity cm/sec

  vb=0.0077
  vbridges=(v/vb)^(-0.234)

  nwin,xs=500,ys=400
  plot,v,vbridges<1,xr=[0,2],xtitle='IMPACT VELOCITY (cm/sec)',$
       ytitle=textoidl('COEFFICIENT OF RESTITUTION \epsilon_N'),$
       thick=3,charsize=cplot,pos=[0.22-.12,0.2,0.85,0.9],$
       title='LABORATORY MEASUREMENTS OF ICE',col=col1
  oplot,v,vbridges<1,col=2,thick=3

  r=20.
  gamma=-0.01*r+0.41
  vhatzes=0.9*exp(-gamma*v)+0.002*v^(-0.9)
  oplot,v,vhatzes,col=3,lines=0,thick=3
  
  xyouts,0.2,0.22,"Bridges et al. 1984 ('FROSTY')",charsize=1.55*c8,col=2
  xyouts,0.7,0.82,"Hatzes et al. 1988 ('SMOOTH')",charsize=1.55*c8,col=3
  
psdirect,program+'_1',ps,/vfont,/stop


;-----------------------------------------
psdirect,program+'_2',ps,/color,xsize=18,ysize=18.*400./900.

   col1=1
   if(!d.name eq 'PS') then col1=0
   nwin,xs=900,ys=400
   plot,lindgen(10),/nod,xs=15,ys=15
   !p.charsize=.9
   tile_to_pos,2,1,pos,page=[.05,.05,.95,.95],fsize=.7

   restore,'rfc_model4_et100.compsave'
   plot,tautab,hitab,/nod,$
        xtitle=textoidl(' OPTICAL DEPTH \tau'),ytitle='GEOMETRIC THICKNESS (m)',$
        yr=[1,200],/ylog,ys=1,xr=[0.1,4],/xlog,col=col1,pos=pos(0,*),/noe
   oplot,tautab,hitab,psym=-6,syms=.5,col=3,thick=2
   oplot,tautab,hvtab,psym=0,syms=.5,col=3,lines=2
   
   restore,'rfc_model1_et100.compsave'
   oplot,tautab,hitab,psym=-6,syms=.5,col=2,thick=2
   oplot,tautab,hvtab,psym=0,syms=.5,col=2,lines=2
   
   xyouts,1.0,80,'SMOOTH',col=3,chars=.65
   xyouts,.3,10,'FROSTY',col=2,chars=.65
   
   restore,'rfc_model4_et100.compsave'
   plot,tautab,(vltab+vnltab)*tautab,/nod,$
        xtitle=textoidl('OPTICAL DEPTH \tau'),$
        ytitle=textoidl('DYNAMIC VISCOSITY  (\tau\nu)'),$
        yr=[.1,100],/ylog,xr=[0.1,4],/xlog,col=col1,pos=pos(1,*),/noe
   oplot,tautab,(vltab+vnltab)*tautab,psym=-6,syms=.5,col=3,thick=2
   oplot,tautab,(vltab)*tautab,col=3,lines=2
   
   restore,'rfc_model1_et100.compsave'
   oplot,tautab,(vltab+vnltab)*tautab,psym=-6,syms=.5,col=2,thick=2
   oplot,tautab,(vltab)*tautab,col=2,lines=2
   
   xyouts,0.15,50,'SMOOTH',col=3,chars=.65
   xyouts,.15,0.7,'FROSTY',col=2,chars=.65


psdirect,program+'_2',ps,/stop




defplot
!p.multi=0
end
