;******************************
;hsfig0.pro >- GGNEW_fig1.pro
;eps(TAU) relationship
;******************************

program='cassini_hsfig0'
ps=0
psdirect,program,ps,/col,xsize=12.*1.5,ysize=8.*1.5

nwin
eps=0.685+(1.-0.685)/100.*findgen(200)
taueps_ha,eps,tau

taugt=tau
epsgt=(1-0.61/(1+taugt^2))^0.5

;these are traced (with a ruler) from GT78 Fig.2
;deviates quite a lot from the formula, consistent with Stewart84
tau1=lindgen(11)*.1
epsgt1=[0.627083,     0.631250,     0.642,     0.658750,     0.679,     0.702083,     0.726250,     0.750000,     0.775000,  0.795833,     0.814583 ]


tau2=lindgen(9)*.5
epsgt2=[0.627,0.70,0.815,0.88,0.925,0.945,0.961,0.97,0.974]



tau2=lindgen(12)*.25+1.25
epsgt2=[ 0.854167,     0.883333,     0.905417,     0.924167,     0.938750,     0.945833,     0.954167,     0.960833,     0.965833,     0.969583,0.972917 , 0.9745000]


taugt=[tau1,tau2]
epsgt=[epsgt1,epsgt2]

res=poly_fit(taugt,epsgt,7,yfit=epsgt_sm)

taugt_sm=findgen(401)*.01
epsgt_sm=taugt_sm*.0
for i=0,n_elements(res)-1 do begin
epsgt_sm=epsgt_sm+res(i)*taugt_sm^(i)
endfor

plot,tau,eps,xr=[0,4],yr=[0.4,1],xtitle=textoidl('\tau'),ytitle=textoidl('\epsilon_{cr}'),lines=2,thick=2,charsize=1.
;oplot,taugt,epsgt,thick=1,lines=0,psym=1
oplot,taugt_sm,epsgt_sm,thick=1,lines=0
;oplot,tau2,epsgt2,thick=1,col=5,psym=6
;oplot,tau1,epsgt1,thick=1,col=5,psym=1

xyouts,0.2,0.75,'HA78'
xyouts,0.2,0.59,'GT78'

;bridges
restore,'tb_iimodel1_a100_2008.compsave.epsn'
ind_use=[0,1,2,4,7,8,9,10,11,12,13,14,15,16,17,18]
oplot,tautab(ind_use),epsnvntab(ind_use),psym=6,col=2,thick=2


;hatzes 20cm
restore,'ikiturso_iimodel6_et100.compsave.epsn'
oplot,tautab,epsnvntab,psym=6,thick=2,col=4



psdirect,program,ps,/col,/stop
end





















