;asyfig2t_schema1.pro asypap1_fig_schema1.pro 

pro dpsplot2_apu,angle,rad,length,p1,p2,oplot=oplot,$
line=line,label=label,dl=dl,wake=wake,half=half,box=box,xmui=xmui,ymui=ymui


;coordinates of line 
cosa=cos(angle/!radeg)
sina=sin(angle/!radeg)

bangle=angle+90.+21.
cosb=cos(bangle/!radeg)
sinb=sin(bangle/!radeg)

x12=cosa*rad
y12=sina*rad

xmui=x12
ymui=y12

x2=x12+length*cosb
y2=y12+length*sinb
x1=x12-length*cosb
y1=y12-length*sinb
thick=4
;original thick=1
if(keyword_set(half)) then begin
x2=x12
y2=y12
thick=4
;original thick=5
endif

p1=[x1,x2]
p2=[y1,y2]
if(keyword_set(oplot)) then oplot,p1,p2,thick=thick
if(keyword_set(line)) then oplot,[0,x12],[0,y12],lines=2
if(keyword_set(label)) then begin
dlx=0
dly=0
if(keyword_Set(dl)) then begin
dlx=dl(0)
dly=dl(1)
endif
xyouts,x12*0.7+dlx,y12*0.7+dly,/data,label
endif


if(keyword_set(box)) then begin
print,'here'
cosa=cos(angle/!radeg)
sina=sin(angle/!radeg)
bangle=angle+90
cosb=cos(bangle/!radeg)
sinb=sin(bangle/!radeg)

length9=box*length
x12=cosa*(rad-length9)
y12=sina*(rad-length9)
x2=x12+length9*cosb
x1=x12-length9*cosb
y2=y12+length9*sinb
y1=y12-length9*sinb
oplot,[x1,x2],[y1,y2]

x12=cosa*(rad+length9)
y12=sina*(rad+length9)
xx2=x12+length9*cosb
xx1=x12-length9*cosb
yy2=y12+length9*sinb
yy1=y12-length9*sinb
oplot,[xx1,xx2],[yy1,yy2]

oplot,[x1,xx1],[y1,yy1]
oplot,[x2,xx2],[y2,yy2]

endif


return
end

;**********************
;dpsplot2.pro


program='asyfig2t_schema1_2008'
ps=0.1
psdirect,program,ps

tek_color
;nwin,/large
nwin,xs=640*1.25,ys=512*1.25
xylim,2
sbox,1
pos=[0.1,0.3,0.9,0.7]
pos=[0.1,0.5,0.9,0.9]

;plot,lindgen(1),/nodata,xr=[-1,1]*2,yr=[-1,1]*2,xs=15,ys=15,pos=pos,$
;title='AZIMUTHAL ASYMMETRY DUE TO LOCAL WAKES ? !C !C !C !C !C',charsize=0.8

plot,lindgen(1),/nodata,xr=[-1,1]*2,yr=[-1,1]*2,xs=15,ys=15,pos=pos

;tvcircle,0.6,0.,0.,/data,col=3
fii=findgen(4001)/4000.*2*!Pi

sinf=sin(fii)
cosf=cos(fii)
aspect=0.8/0.4*1.25
xcir=0.6*cosf
ycir=0.6*sinf*aspect


xx=(1.3-0.35)*cosf
yy=(1.3-0.35)*sinf*1.25


n50=500
index=3000-n50+lindgen(2*n50)
xcir_ori=xcir(index)
ycir_ori=ycir(index)
ycir(index)=yy(index)
xcir(index)=xx(index)


polyfill,xcir,ycir,/line_fill
plots,xcir,ycir,lines=0
plots,xcir_ori,ycir_ori,lines=2

;tvcircle,0.6,0.,0.,/data,/fill,/line_f,col=3

;tvcircle,1.3-0.35,0.,0.,/data
;tvcircle,1.3+0.35,0.,0.,/data

fac=0.5
;tvellipse,0.6,0.6*fac,0.,0.,/data,col=3
;tvellipse,0.6,0.6*fac,0.,0.,/data,/fill,/line_f,col=3

;tvellipse,1.3-0.35,(1.3-0.35)*fac,0.,0.,/data
;tvellipse,1.3+0.35,(1.3+0.35)*fac,0.,0.,/data

xx=(1.3+0.35)*cos(fii)
yy=(1.3+0.35)*sin(fii)*1.25
plots,xx,yy,psym=3,col=1

lim=28
fiit=fii*!radeg
indf=where(fiit lt 90.-lim or fiit gt 90.+lim)
fii=fii(indf)
xx=(1.3-0.35)*cos(fii)
yy=(1.3-0.35)*sin(fii)*1.25
plots,xx,yy,psym=3,col=1

!p.color=2
;uncommented
;dpsplot2_apu,65,1.25,0.2,/oplot
;dpsplot2_apu,65,1.30,0.2,/oplot,/line,label='155!Eo!N',dl=[0.,-0.25]
;dpsplot2_apu,65,1.35,0.2,/oplot

;dpsplot2_apu,65+180,1.25,0.2,/oplot
;dpsplot2_apu,65+180,1.30,0.2,/oplot,/line,label='335!Eo!N',dl=[-0.25,0.15]
;dpsplot2_apu,65+180,1.35,0.2,/oplot


!p.color=2
s125=1.2*1.2
s130=1.30*1.2
s135=1.40*1.2

s125=1.2*1.25
s130=1.30*1.25
s135=1.40*1.25

s02=0.25

a65=69.
a75=a65+10.

dpsplot2_apu,a65+0,s125,s02,/oplot
dpsplot2_apu,a65+0,s130,s02,/oplot,/line,label='',dl=[0.05,0.15]*2
dpsplot2_apu,a65+0,s135,s02,/oplot
dpsplot2_apu,a65+0,s125,s02,/oplot,/half
dpsplot2_apu,a65+0,s130,s02,/oplot,/half,box=0.9,xmui=xmui1,ymui=ymui1
dpsplot2_apu,a65+0,s135,s02,/oplot,/half


dpsplot2_apu,a65+180,s125,s02,/oplot
dpsplot2_apu,a65+180,s130,s02,/oplot,/line,label='',dl=[0.05,0.15]*2
dpsplot2_apu,a65+180,s135,s02,/oplot
dpsplot2_apu,a65+180,s125,s02,/oplot,/half
dpsplot2_apu,a65+180,s130,s02,/oplot,/half,box=0.9,xmui=xmui1,ymui=ymui1
dpsplot2_apu,a65+180,s135,s02,/oplot,/half

!p.color=5
s125=1.2
s130=1.30
s135=1.40
s02=0.28

dpsplot2_apu,a65+90,s125,s02,/oplot
dpsplot2_apu,a65+90,s130,s02,/oplot,/line,label='',dl=[0.05,0.15]*2
dpsplot2_apu,a65+90,s135,s02,/oplot
dpsplot2_apu,a65+90,s125,s02,/oplot,/half
dpsplot2_apu,a65+90,s130,s02,/oplot,/half,box=0.9,xmui=xmui1,ymui=ymui1
dpsplot2_apu,a65+90,s135,s02,/oplot,/half




dpsplot2_apu,a65+270,s125,s02,/oplot
dpsplot2_apu,a65+270,s130,s02,/oplot,/line,label='',dl=[-0.05,0.15]*2
dpsplot2_apu,a65+270,s135,s02,/oplot
dpsplot2_apu,a65+270,s125,s02,/oplot,/half
dpsplot2_apu,a65+270,s130,s02,/oplot,/half,box=0.9,xmui=xmui2,ymui=ymui2
dpsplot2_apu,a65+270,s135,s02,/oplot,/half

!p.color=1
dpsplot2_apu,-90,2.6,0.,/oplot,/line,label='0!Eo!N',dl=[0.05,0]

!p.color=2
dpsplot2_apu,a65,2.85,0.,label='MAX: 159!Eo!N',dl=[0.,0.1]
dpsplot2_apu,a65+180,2.85,0.,label='MAX: 339!Eo!N',dl=[-0.4,-0.4]
;dpsplot2_apu,65+180,2.8,0.,label='MAX',dl=[-0.2,0]
!p.color=5
dpsplot2_apu,a75+90,2.75,0.,label='MIN: 249!Eo!N',dl=[-.35,0.1]
dpsplot2_apu,a75+180+90,2.75,0.,label='MIN: 69!Eo!N ',dl=[-0.2,-0.15]
!p.color=1

arrow,0,-2.8,0,-.8,/data
xyouts,0,-3.2,ali=0.5,'OBSERVER'


;arrow,-0.25*2.8, -0.75*2.8,-0.25*.8, -0.75*.8,/data
;xyouts,-0.25*3.2,-0.75*3.2,ali=0.5,'SUN'

;goto,endi
arrow,xmui1-0.25,ymui1-0.75,xmui1,ymui1,/data,hsize=-0.001
arrow,xmui2-0.25,ymui2-0.75,xmui2,ymui2,/data,hsize=-0.001

arrow,xmui1-0.0,ymui1-0.75,xmui1,ymui1,/data,hsize=-0.001
arrow,xmui2-0.0,ymui2-0.75,xmui2,ymui2,/data,hsize=-0.001

xyouts,xmui1-0.25-0.2,ymui1-0.75-0.2,'SUN',chars=0.01
xyouts,xmui1,ymui1-0.75-0.2,'OBS',chars=0.01


xyouts,xmui2-0.25-0.2,ymui2-0.75-0.2,'SUN',chars=0.01
xyouts,xmui2,ymui2-0.75-0.2,'OBS',chars=0.01
endi:

goto,nosave
restore,'nr450a130n4_100.pos42'
sst=ss
zzt=zz
lim=1.25
mosa_box_f,xx,yy,xl,orb,runid,zztemp=zzt,sstemp=sst,xxt,yyt,xw=lim*xl,yw=lim*xl
draft=1.75
side_xyz,xxt,yyt,zzt,sst,xl,view=[-249,12],draft=draft,light=[-245,15],save='asyfig2t_schema2_pos42_249_12.save',/w600
side_xyz,xxt,yyt,zzt,sst,xl,view=[-339,12],draft=draft,light=[-335,15],save='asyfig2t_schema2_pos42_339_12.save',/w600
nosave:

restore,'asyfig2t_schema2_pos42_249_12.save'
ima2=rebin(imageview,300,300)
ima2=ima2(*,50:200)
!p.position=[0.03,0.07, 0.48,0.5]
!x.style=15
!y.style=15
loadct,0
tvplot2,255-ima2,/asp,/noe,/nonew,/noaxi

restore,'asyfig2t_schema2_pos42_339_12.save'
ima5=rebin(imageview,300,300)
;ima5=imageview
ima5=ima5(*,50:200)
!p.position=[0.52, 0.07, 0.97,0.5]
tvplot2,255-ima5,/asp,/noe,/nonew,/noax

st=textoidl('\theta=249^o, B=12^0')
xyouts,0.14,0.1,st,/nor,col=1
st=textoidl('\theta=339^o, B=12^0')
xyouts,0.65,0.1,st,/nor,col=1
;xyouts,0.01,0.01,'asyfig2t_schema1.pro',/normal,chars=.75
;image=tvrd(0,0,640*1.2,512*1.2)
;nwin,xs=640*1.2,ys=480
;tv,image(*,60:60+479)

psdirect,program,ps,/stop

end










