;**********************************
pro mc_wread_2pos_f,jobide,plot=plot,nosave=nosave,$
                    restorefile=restorefile,yrmax0=yrmax0,tau0=tau0,$
                    print0=print0,xrmax0=xrmax0,enhanced=enhanced,$
                    oppo_enhanced=oppo_enhanced,$
                    psym0=psym0,survey=survey,$
                    hst=hst,ms_hst=ms_hst,alb_hst=alb_hst,$
                    lambert_hst=lambert_hst,$
                    lumme_hst=lumme_hst,rx=rx,ry=ry,$
                    FIT=FIT,ylog0=ylog0,xlog0=xlog0,comp=comp,$
                    oe=oe,spokes=spokes,scomp=scomp,symm=symm

;**********************************

if(n_params() le 0) then begin
    print,' mc_wread_2pos_f,jobide,plot=plot,nosave=nosave'
    print,' restorefile=restorefile,yrmax0=yrmax0'
    print,' this procedure is used for reading both opposition-effect'
    print,' and tilt-effect runs'
    print,' input   <- jobide.w'
    print,' output  -> jobide.outwsave'
    print,'/enhanced'
    print,'/oppo_enhanced'
    print,'/survey   ->jobide.outwsave2'
    print,'print=-1 --> works silently'     
    return
endif

psym=0
if(keyword_set(psym0)) then psym=psym0

yrmax=1.
if(keyword_set(yrmax0)) then yrmax=yrmax0

xrmax=0.
if(keyword_set(xrmax0)) then xrmax=xrmax0

outfile=jobide+'.w'
savefile=jobide+'.outwsave'
savefile2=jobide+'.outwsave2'

iprint=0
if(keyword_set(print0)) then iprint=print0


if(not keyword_set(restorefile)) then begin
;print,'outfile'
;read,outfile
    close,1
    openr,1,outfile,error=stat

;old name? (.www instead of .w)
    if(stat ne 0) then begin
        close,1
        openr,1,jobide+'.www',error=stat
    endif

    if(stat ne 0) then return

    posfile=''

    nphot=0l
    maxscat=0l
    nbox=0l
    nboxvis=0l
    idum=0l
    m10=10

readf,1,versio
readf,1,posfile
readf,1,sunfii,sunlat,nphot
readf,1,ssca,maxscat,nbox,nboxvis,idum
if(iprint ge 0) then begin
    print,'maxscat,nbox,nboxvis,idum'
    print,maxscat,nbox,nboxvis,idum
endif
if(versio ge 1) then readf,1,method

ppar1=-999.
ppar2=-999.
ppar3=-999.
if(versio ge 5) then readf,1,ppar1,ppar2,ppar3
if(versio ge 6) then readf,1,m10

 
smethod=' '
if(method eq 1)  then smethod='LAMBERT-ELEMENT'
if(method eq 11) then smethod='LAMBERT-SPHERE-CENTER'
if(method eq 12) then smethod='LAMBERT-SPHERE-POINT'
if(method eq 3)  then smethod='HG-SPHERE-CENTER  '+string(ppar1,'(f7.4)')
if(method eq 4)  then smethod='HG-SPHERE-POINT  '+string(ppar1,'(f7.4)')
if(method eq 13) then smethod='HG2-SPHERE-CENTER  '+$
  string(ppar1,'(f7.4)')+string(ppar2,'(f7.4)')+string(ppar3,'(f7.4)')
if(method eq 14) then smethod='HG2-SPHERE-POINT  '$
  +string(ppar1,'(f7.4)')+string(ppar2,'(f7.4)')+string(ppar3,'(f7.4)')
if(method eq 5)  then smethod='EULER-SPHERE-CENTER  '+string(ppar1,'(f7.4)')
if(method eq 6)  then smethod='EULER-SPHERE-POINT  '+string(ppar1,'(f7.4)')
if(method eq 7)  then smethod='CALLISTO-SPHERE-CENTER  '
if(method eq 8)  then smethod='CALLISTO-SPHERE-POINT  '
if(method eq 9)  then smethod='POWER-SPHERE-CENTER  '+string(ppar1,'(f7.4)')
if(method eq 10) then smethod='POWER-SPHERE-POINT  '+string(ppar1,'(f7.4)')


readf,1,ntest
if(iprint ge 0) then begin
    print,'-----------------------------------------------------------'
    print,'jobide= ',jobide
    print,'posdat= ',posfile
    if(versio ge 3) then begin
        if(versio eq 3) then print,'mc_test3: testd corrected, also testd_corr'
        if(versio eq 4) then print,'SEP2000: testd corrected, also testd_corr'
        if(versio eq 5) then print,'JAN2001'
        if(versio eq 6) then print,'halla feb/2003'
        print,'Nphot=',nphot
        print,'number of orders stored',m10
        print,'method',method,'   ',smethod
    endif
endif


no_indir=0
ntest_orig=ntest
if(ntest eq 0) then no_indir=1
if(ntest eq 0) then ntest=1
testfii=fltarr(ntest)
testlat=testfii
testw=testfii
testn=testfii
testd=testfii
testm=fltarr(ntest,m10)

;2pos
testm_2pos=fltarr(ntest,21,51)



testd_corr=testfii
ntest=ntest_orig
if(ntest ne 0) then begin
    readf,1,testfii
    readf,1,testlat
    readf,1,testw
    readf,1,testn
    readf,1,testd
    if(versio ge 3) then readf,1,testd_corr
    readf,1,testm



    if(versio ge 7) then begin
        if(iprint gt 0) then print,'_2pos-output:'
        posfile_haze=''
        readf,1,posfile_haze
        if(iprint gt 0) then print,'posfile_haze',posfile_haze
        readf,1,method_haze
        if(iprint gt 0) then print,'method_haze',method_haze
        readf,1,ppar1_haze,ppar2_haze,ppar3_haze
        if(iprint gt 0) then print,1,ppar1_haze,ppar2_haze,ppar3_haze

        readf,1,ssca_part, ssca_haze
        if(iprint gt 0) then print,ssca_part, ssca_haze
        readf,1,norder_part,norder_haze

        readf,1,testm_2pos
    endif


endif


readf,1,iscat_mean,npot_mean,nbox_mean
readf,1,npartori,npart,mx,my
if(iprint ge 0) then begin
    print,'Npart=',npartori,npart
;    print,'iscat_mean,npot_mean,nbox_mean'
;    print,iscat_mean,npot_mean,nbox_mean
    print,'iscat_mean,npot_mean,nbox_mean',iscat_mean,npot_mean,nbox_mean
endif

if(versio ge 2) then begin
    readf,1,sredu,zredu,tau
    readf,1,fdirect,taub,tau_n
    readf,1,cpu,cpu_comp
endif
sizemin=0
s20=0.
f20=0.
if(versio ge 4) then begin
    readf,1,sizemin,s20,f20
endif


close,1
endif                           ;no restore

if(keyword_set(restorefile)) then begin
    resfile=restorefile
    if(resfile eq 'def') then resfile=jobide+'.outwsave'
    restore,resfile
    print,'restored from:',resfile
endif

if(iprint ge 0) then begin
    print,'sredu,zredu,tau',sredu,zredu,tau
    print,'fdirect,taub,tau_n'
    print,fdirect,taub,abs(tau_n)
    print,'cpu,cpu_comp'
    print,cpu,cpu_comp
endif

;INDIRECT METHOD
;normalize to I/F
bsun=sunlat
bobs=testlat
ind=where(bobs eq 0,count)
if(count ge 1) then bobs(ind)=0.01

;IMPORTANT!
;see Eq. (16) in SK2003:
;variable testm contains the accumulated weight
;factor of pi is omitted here, since the phase functions used in 
;mc_sub_XXX.for contain an extra pi

iperf=abs(sin(sunlat/!radeg)/nphot/sin(testlat/!radeg)) 

;different for each bobs

;I/F=iperf*testw
;d(I/F)=iperf*testd    but this error estimate is questionable!
;d(I/F)=iperf*testd_corr   correct error?

if_test=iperf*testw
dif_test=iperf*testd_corr
if_ss_test=iperf*testm(*,0)

;this is valid only after 17.05.01
dif_ss_test=iperf*testd

;***************************************************************
;theoretical ss-flux
;***************************************************************
;both using tau=tau_dyn and tau=tau_n



ar=!dpi/180.d0
ra=1.d0/ar

mu0=sin(bsun*ar)
mu=sin(bobs*ar)
dlobs=sunfii-testfii
if(iprint ge 1) then begin
    print,'THEORETICAL SS-flux'
    print,'bsun,mu0',bsun,mu0
    print,'bobs',bobs
    print,'mu',mu
    print,'dfii',dlobs
endif

cos_alpha=cos(dlobs*ar)*cos(bsun*ar)*cos(bobs*ar)+sin(ar*bobs)*sin(bsun*ar)
cos_alpha=cos_alpha<1.d0>(-1.d0)
alpha=acos(cos_alpha)

;*************************************
;phase function

phasef=0.
if(method eq 2) then phasef=1./4./!pi

if(method eq 1 or method eq 11 or method eq 12) then begin
    if(iprint eq 1) then    print,'LAMBERT',method
    s=!dpi-alpha
    cosa=cos(s)
    sina=sin(s)
    vak=1.d0/!dpi^2/3.d0*2.d0
    phasef=vak*(sina-s*cosa)
endif

if(method eq 3 or method eq 4) then begin
    g=ppar1
    if(iprint eq 1) then print,'HG',method,g
    cosa=cos(!pi-alpha)
    phasef=1./4./!pi*(1.-g^2)/(1.-2*g*cosa+g^2)^(1.5)
endif


if(method eq 13 or method eq 14) then begin
    g1=ppar1
    g2=ppar2
    bb=ppar3
    if(iprint eq 1) then print,'HG2',method,g1,g2,bb
    cosa=cos(!pi-alpha)
    phasef1=1./4./!pi*(1.-g1^2)/(1.-2*g1*cosa+g1^2)^(1.5)
    phasef2=1./4./!pi*(1.-g2^2)/(1.-2*g2*cosa+g2^2)^(1.5)
    phasef=bb*phasef1+(1.-bb)*phasef2
endif

if(method eq 7 or method eq 8) then begin
    if(iprint eq 1) then print,'CALLISTO',method
    s=!pi-alpha
    phasef=0.153*s^3.092/4./!pi
endif

;***************************************
;ss-flux


amu=abs(mu)
amu0=abs(mu0)
ss_theory=amu*0.

for itau=1,2 do begin

;with tau_dyn
    if(itau eq 1) then tau_use=tau
;with tau_n
    if(itau eq 2) then tau_use=abs(tau_n)
    tau_path=tau_use*(1.d0/amu+1.d0/amu0)
    
    indpos=where(mu*mu0 gt 0,count)
    if(count ge 1) then begin
;        print,'indpos',count
        ss_theory(indpos)=amu0*phasef(indpos)*$
          (1.-exp(-tau_path(indpos)))/4./(amu0+amu(indpos))*4*!pi
    endif
    indneg=where(mu*mu0 lt 0,count)
    if(count ge 1) then begin
;        print,'indneq',count
        ss_theory(indneg)=amu0*phasef(indneg)*$
          (exp(-tau_use/amu(indneg))-exp(-tau_use/amu0))$
          /4./(amu(indneg)-amu0)*4*!pi
    endif
    ind_eq=where(mu eq -mu0,count)
    if(count ge 1) then begin
;        print,'indeq',count
        ss_theory(ind_eq)=phasef(ind_eq)*$
          tau_use/amu0*exp(-tau_use/amu0)/4.*4*!pi
    endif


if(iprint ge 0) then print,'ss-flux using tau=',tau_use,ss_theory(0)

    if(itau eq 1) then begin
        tau_path_dyn=tau_path
        ss_theory_dyn=ss_theory
    endif

endfor

;******************************************************************
if(iprint ge 0) then begin
    print,'alpha',alpha/ar
    print,'phasef',phasef
    print,'ss_theory',ss_theory
    print,'ss-indirect',if_ss_test
endif

if(keyword_set(plot)) then begin
    nwin
    !p.multi=[0,2,1]

    plot,testlat,iperf*testw,xtitle='lat',ytitle='I/F',title=savefile,$
      yr=[0,yrmax],ys=1,xr=[0,xrmax],psym=psym
    oplot,testlat,iperf*testm(*,0),psym=psym
    oplot,testlat,ss_theory,lines=2,col=2,psym=psym

    plot,testfii,iperf*testw,xtitle='fii',ytitle='I/F',$
      yr=[0,yrmax],ys=1,xr=[0,xrmax],psym=psym
    oplot,testfii,iperf*testm(*,0),psym=psym
    oplot,testfii,ss_theory,lines=2,col=2,psym=psym
    xyouts,0.01,0.01,/normal,'mc_wread_f.pro '+!stime,chars=.6
    !p.multi=0
endif

if(keyword_set(enhanced)) then begin
    if(enhanced eq 1) then begin
        nwin
        plot,testlat,iperf*testm(*,0)/ss_theory,$
          xtitle='elevation B',ytitle='SS/SS-THEORY',$
          psym=psym,title=savefile,xr=[0,xrmax]
    endif
    if(enhanced gt 1) then oplot,testlat,iperf*testm(*,0)/ss_theory,$
      col=enhanced,psym=psym
endif


if(keyword_set(comp)) then begin
    
    apu=iperf*testm(*,0)
    ytitle_use='I/F SS'
    if(keyword_set(alb_hst)) then begin
        albedo,testm,apu,alb_hst
        apu=apu*iperf
        ytitle_use='I/F ALB='+string(alb_hst,'(f6.3)')
    endif
    if(comp eq 1) then begin
        nwin
        plot,alpha*!radeg,apu,xtitle='phase angle',$
          ytitle=ytitle_use,psym=psym,title=savefile,xr=[0.01,10],xs=1,/xlog
    endif
    if(comp gt 1) then oplot,alpha*!radeg,apu,col=comp,psym=psym
endif



if(keyword_set(oppo_enhanced)) then begin
    oe=fltarr(2)
    oe(0)=tau_path(0)
    oe(1)=iperf(0)*testm(0,0)/ss_theory(0)-1
    if(oppo_enhanced eq 1) then begin
        nwin
        plot,alpha*!radeg,iperf*testm(*,0)/ss_theory-1,xtitle='phase angle',$
          ytitle='(SS/SS_THEORY)-1',psym=psym,title=savefile,xr=[0,xrmax]
    endif
    if(oppo_enhanced gt 1) then oplot,alpha*!radeg,$
      iperf*testm(*,0)/ss_theory-1.,$
      col=oppo_enhanced,psym=psym
endif

;****************************************************************


if(not keyword_set(restorefile)) then begin
    if(not keyword_set(nosave)) then begin

        if(versio lt 7) then testm_2pos=0.

        save,file=savefile,testlat,testfii,testw,testd,$
          testm,testd_corr,versio,posfile,jobide,$
          sunfii,sunlat,nphot,ssca,maxscat,nbox,nboxvis,$
          idum,method,ntest,testn,iscat_mean,$
          npot_mean,nbox_mean,npartori,npart,mx,my,sredu,$
          zredu,tau,fdirect,tau_path,tau_n,$
          cpu,cpu_comp,iperf,iperf,ppar1,ppar2,ppar3,$
          ss_theory,alpha,if_ss_test,taub,$
          tau_path_dyn,ss_theory_dyn,testm_2pos
  if(iprint ge -1) then       print,'saved to ',savefile
    endif
endif


;***********************************************************************
;halla_survey
;***********************************************************************
index=where(testfii eq testfii(0),count)
nlat=count
nfii=n_elements(testfii)/nlat

ss_2dtab=fltarr(nfii,nlat)
tt_2dtab=fltarr(nfii,nlat)
dd_2dtab=fltarr(nfii,nlat)
fii_2dtab=fltarr(nfii,nlat)
lat_2dtab=fltarr(nfii,nlat)
alpha_2dtab=fltarr(nfii,nlat)
ms_2dtab=fltarr(nfii,nlat)
tau_path_2dtab=fltarr(nfii,nlat)
tau_path_dyn_2dtab=fltarr(nfii,nlat)


apu1=testm(*,0)*iperf
apu2=ss_theory
apu3=ss_theory_dyn

;albedo,testm,testa,0.5,pr=1d-16
albedo,testm,testa,1.,pr=1d-16
apu4=testa*iperf

for i=0,nfii-1 do begin
    ind=index+i*nlat
    ss_2dtab(i,*)=apu1(ind)
    tt_2dtab(i,*)=apu2(ind)
    dd_2dtab(i,*)=apu3(ind)
    fii_2dtab(i,*)=testfii(ind)
    lat_2dtab(i,*)=testlat(ind)
    alpha_2dtab(i,*)=alpha(ind)
    ms_2dtab(i,*)=apu4(ind)
    tau_path_2dtab(i,*)=tau_path(ind)
    tau_path_dyn_2dtab(i,*)=tau_path_dyn(ind)
endfor

if(not keyword_set(nosave)) then begin
    save,file=savefile2,nlat,nfii,ss_2dtab,tt_2dtab,dd_2dtab,$
      fii_2dtab,lat_2dtab,alpha_2dtab,ms_2dtab,$
      savefile2,sunfii,sunlat,method,npart,cpu,jobide,posfile,nphot,$
      tau_path_2dtab,tau_path_dyn_2dtab
    if(nlat gt 1 and nfii gt 1) then begin
        print,'grid save to ',savefile2
        print,'nfii,nlat=',nfii,nlat
    endif
endif


if(keyword_set(spokes)) then begin
    nwin
    LEVT=FINDGEN(21)*.05
    levt2=[0.5,1.0,1.5]
    contour,ms_2dtab+ss_2dtab,lev=levt,fii_2dtab,lat_2dtab,$
      c_col=findgen(21)*8+100,yr=[-60,90],xr=[0,180],xs=1,ys=1,$
      title=jobide+string(sunlat)+string(nphot),/irr,/fill,/c_anno
endif






if(keyword_set(survey)) then begin
    nwin
    lev=1.5
    if(n_elements(survey) gt 1) then lev=survey

    LEVT=0.5+FINDGEN(11)*.1
    levt2=[0.5,1.0,1.5]
    contour,ss_2dtab/(tt_2dtab>1d-16),lev=levt,fii_2dtab,lat_2dtab,$
      c_col=findgen(11)*15+100,yr=[-60,90],xr=[0,180],xs=1,ys=1,$
      title=jobide+string(sunlat)+string(nphot),/irr,/fill,/c_anno

    contour,ss_2dtab/(tt_2dtab>1d-16),lev=levt2,fii_2dtab,lat_2dtab,$
      c_col=0,yr=[-60,90],xr=[0,180],xs=1,ys=1,/noerase,/over,/c_anno

    contour,ss_2dtab/(tt_2dtab>1d-16),lev=lev,fii_2dtab,lat_2dtab,$
      c_col=1,yr=[-60,90],xr=[0,180],xs=1,ys=1,/noerase,/over,c_lines=2
endif




if(keyword_set(hst)) then begin

;make spline-fit for normalization

    iuse=0
    if(keyword_set(ms_hst)) then iuse=ms_hst
    apu=iperf*testm(*,iuse)
    ytitle='I/I6.38, scattering order='+string(iuse,'(i2)')

    if(keyword_set(alb_hst)) then begin
        albedo,testm,apu,alb_hst
        apu=apu*iperf
        ytitle='I/I6.38, Albedo='+string(alb_hst,'(f6.3)')+'  '+smethod
    endif




    xarg=max(alpha)/10000.*findgen(10000)  ;radians

yarg=interpol(apu,alpha,xarg)
;    y2=spl_init(alpha(1:*),apu(1:*))
;    yarg=spl_interp(alpha(1:*),apu(1:*),y2,xarg,/double)
    dabs=abs(xarg*!radeg-6.38)
    ind=where(dabs eq min(dabs))
    apu_norm=yarg(ind(0))
    

    if(hst eq 1) then begin
        xr=[.05,10]
        if(keyword_set(xrmax0)) then xr=[0.05,xrmax0]
        if(keyword_set(rx)) then xr=[rx(0),rx(1)]
        
        yr=[0.9,2.]
        if(keyword_set(ry)) then yr=[ry(0),ry(1)]
        ylog=0
        if(keyword_set(ylog0)) then ylog=ylog0
        xlog=1
        if(keyword_set(xlog0)) then xlog=nint(xlog0)

        nwin
        plot,alpha*!radeg,apu/apu_norm,xtitle='phase angle',$
          ytitle=ytitle,psym=6,title=savefile,xr=xr,xlog=xlog,$
          xs=1,yr=yr,ys=1,ylog=ylog
        oplot,xarg*!radeg,yarg/apu_norm
        PLOTS,6.36,1,PSYM=1
    endif

    if(hst gt 1) then oplot,alpha*!radeg,apu/APU_NORM,$
      col=hst,psym=6
    if(hst gt 1) then oplot,xarg*!radeg,yarg/apu_norm,col=hst

    if(keyword_set(lambert_hst)) then begin
        alfa=findgen(10000)/1000.*6.38
        phasef,alfa,pl,pc,/nop
        oplot,alfa,pl/pl(1000)*lambert_hst,lines=2
        oplot,alfa,pc/pc(1000)*lambert_hst,lines=1
    endif

    if(keyword_set(lumme_hst)) then begin
        alfa=findgen(2000)/1000.*6.38
        lumme83_fit,alfa,lumme_hst,ir,ib

        oplot,alfa,ir/ir(1000),col=2,lines=2
        oplot,alfa,ib/ib(1000),col=4,lines=2
        lumme83_fit,alfa,lumme_hst,ir,ib
        oplot,alfa,ir/ir(1000),col=2,lines=4
        oplot,alfa,ib/ib(1000),col=4,lines=4
;        label_data,0.5,0.9,['L83: B=26','L83: B=6'],lines=[2,4]
    endif
    if(keyword_set(fit)) then begin
        index=where(alpha*!radeg gt fit(0) and alpha*!radeg le fit(1))
        oplot,alpha(index)*!radeg,apu(index)/apu_norm,psym=4,thick=2,col=hst

        fit_piironen,alpha(index)*!radeg,apu(index)/apu_norm,$
          oplot=hst-1,amp=amp_b,hw=hw_b,aout=aout
        alfa=findgen(10000)/1000.*6.38
        func_piironen,alfa/!radeg,aout,func
        oplot,alfa,func,col=hst,lines=1
        print,'AMP,HWHM=',amp_b,hw_b
    endif

endif


if(keyword_set(scomp)) then begin
tot_2dtab=ms_2dtab+ss_2dtab
restore,scomp+'.outwsave2'
diff=-(ms_2dtab+ss_2dtab-tot_2dtab)

goto,not2
    nwin
    LEVT=FINDGEN(21)*.01-.1

    yrs=[-60,90]
    yrs=[0,30]
    contour,diff,lev=levt,fii_2dtab,lat_2dtab,$
      c_col=findgen(21)*5+120,yr=yrs,xr=[0,180],xs=1,ys=1,$
      title=jobide+string(sunlat)+string(nphot)+'D(I/F)',/irr,/fill,/c_anno
    contour,diff,lev=[-0.1,0.1],fii_2dtab,lat_2dtab,$
      c_col=1,yr=[-60,90],xr=[0,180],xs=1,ys=1,/noerase,/over,c_lines=2

    contour,diff,lev=0.00001,fii_2dtab,lat_2dtab,$
      c_col=1,yr=yrs,xr=[0,180],xs=1,ys=1,/noerase,/over,c_lines=0
not2:


    yrs=[0,30]

    nwin
    LEVT=FINDGEN(21)*.01-.1
    contour,diff/(ms_2dtab+ss_2dtab>1d-5),lev=levt,fii_2dtab,lat_2dtab,$
      c_col=findgen(21)*5+120,yr=yrs,xr=[0,180],xs=1,ys=1,$
      title=jobide+string(sunlat)+string(nphot)+'D(I/F)/(I/F)',/irr,/fill,/c_anno
    contour,diff/(ms_2dtab+ss_2dtab>1d-5),lev=[-0.1,0.1],fii_2dtab,lat_2dtab,$
      c_col=1,yr=yrs,xr=[0,180],xs=1,ys=1,/noerase,/over,c_lines=2

    contour,diff/(ms_2dtab+ss_2dtab>1d-5),lev=[-0.1,0.1]*.5,fii_2dtab,lat_2dtab,$
      c_col=1,yr=yrs,xr=[0,180],xs=1,ys=1,/noerase,/over,c_lines=1



endif





if(keyword_set(symm)) then begin

print,"B' and B       =",sunlat,testlat
mu0=sin(sunlat/!radeg)
tot5=reform(iperf*testw/mu0)
ss5=reform(iperf*testm(*,0)/mu0)

tot5=tot5(0)
ss5=ss5(0)

print,'TOT/mu0, SS/mu0 =', tot5,ss5
print,''
print,'              Khaze=0         1          2           3'  
apu=reform(testm_2pos(*,0,0:3))*iperf/mu0
print,'Kpart=0 ',apu
apu=reform(testm_2pos(*,1,0:3))*iperf/mu0
print,'Kpart=1 ',apu
apu=reform(testm_2pos(*,2,0:3))*iperf/mu0
print,'Kpart=2 ',apu
endif
end





 















