pro mc_testimage_read,ide,testimage=testimage,noplot=noplot,$
                  scanx=scanx,scany=scany,stop=stop,vis=vis,ill=ill,$
                  save=save

if(n_params() le 0) then begin
    print,'---------------------------------------------------------'
    print,'mc_testimage_read,ide,testimage=testimage,noplot=noplot,$'
    print,'           scanx=scanx,scany=scany,stop=stop,vis=vis,ill=ill,$'
    print,'           save=save'
    print,'---------------------------------------------------------'
    print,''
    print,"reads the file ide+'.testimage'"
    print,'variable testimage'
    print,'---------------------------------------------------------'
    return
endif


close,1
openr,1,ide+'.TESTIMAGE'
readf,1,versio

readf,1,npart,xl,yl,sy
readf,1,nphot,npix,ntest
nxpix=npix
nypix=npix

if(versio ge 3) then begin
    readf,1,nxpix,nypix
    readf,1,nxphot,nyphot
endif
print,'nxpix,nypix'
print,nxpix,nypix

print,'nxphot,nyphot'
print,nxphot,nyphot


readf,1,sunlat,sunfii
testlat=fltarr(ntest)
testfii=testlat
readf,1,testlat
readf,1,testfii

ximage=fltarr(nxpix,nypix)
yimage=fltarr(nxpix,nypix)
readf,1,ximage
readf,1,yimage
;print,'read yimage'


if(versio ge 4) then begin
    readf,1,nnmpix,nntpix
endif

ill=lonarr(nxpix,nypix)
vis=lonarr(nxpix,nypix,ntest)
testimage=fltarr(nxpix,nypix,10,ntest)
readf,1,ill
print,'read ill'

apu2=lonarr(nxpix,nypix)
fapu2=fltarr(nxpix,nypix)

for i=0l,ntest-1 do begin
    readf,1,apu2
    vis(*,*,i)=apu2
;    print,'read vis'
    for j=0,9 do begin
        readf,1,fapu2
;        print,'read testimage j=',j
        testimage(*,*,j,i)=fapu2
    endfor
endfor
;print,'read testimage'

max_order=10



;print,'plot to screen (ret=no, y)'
;vast=''
;read,vast
;if(vast eq 'y') then begin

if(not keyword_set(noplot)) then begin

new_orders:
    print,'sum of orders k1-k2 (k1=-1 ->skip)'
    read,k1,k2

    if(k1 le 0) then goto,end_orders

;nwin,xs=npix*1.2,ys=npix*1.2
nwin,xs=nxpix*1.5,ys=nypix*1.5


    k1=k1<10
    k2=k2<10
    apu=testimage(*,*,k1-1)
    if(k2 gt k1) then begin
        for ik=k1,k2 do begin
            apu=apu+testimage(*,*,ik)
        endfor
    endif
    
    apu=sigrange(apu,frac=.99)
    tvscl,apu
    tvscl,apu,0,nypix
    
    tvscl,apu,nxpix,sy/(2*yl)*nypix+1
    tvscl,apu,nxpix,sy/(2*yl)*nypix+nypix+1
    tvscl,apu,nxpix,sy/(2*yl)*nypix-nypix+1
    sorder=' k= '+string(k1,'(i2)')+'-'+string(k2,'(i2)')
    ots,ide+sorder


;particles
    fii=findgen(201)/200*2.*!pi
    sinf=sin(fii)
    cosf=cos(fii)
    
    
    plots,([-1,-1,1,1,-1]*xl+xl)*nxpix/(2.*xl),([-1,1,1,-1,-1]*yl+yl)*nypix/(2.*yl),/dev

    goto,new_orders
endif
end_orders:

scanx=fltarr(nxpix)
scany=fltarr(nypix)

    
for i=0,nxpix-1 do begin
scanx(i)=mean(testimage(i,*))
endfor

for i=0,nypix-1 do begin
scany(i)=mean(testimage(*,i))
endfor



testimage50=testimage(*,*,0)*0.5
testimage100=testimage(*,*,0)
for ik=1,9 do begin
    testimage50=testimage50+testimage(*,*,ik)*0.5^(ik+1)
    testimage100=testimage100+testimage(*,*,ik)
endfor



nphot_per_pix=1.*nyphot*nxphot/nxpix/nypix
iperf=abs(sin(sunlat/!radeg))/abs(sin(testlat/!radeg))/nphot_per_pix


if(keyword_set(save)) then begin
    save,file=ide+'.TESTIMAGE.save',vis,ill,testimage,$
      npart,xl,yl,sy,nxphot,nyphot,sunlat,sunfii,testlat,testfii,$
      testimage50,testimage100,iperf,ide

print,'mean I/F A=1.0',mean(testimage100)*iperf(0)
print,'mean I/F A=0.5',mean(testimage50)*iperf(0)

print,"restore,'"+ide+".TESTIMAGE.save'"
endif

if(keyword_set(stop)) then stop
end







