;-------------------------------------------------------------
;make_posdat_single.pro  /HS 190506
;-------------------------------------------------------------

;This is a main program-type procedure for
;creating low-D uniform particle fields with a 
;given geometric optical depth TAU
;and particle number N
;see SK2003 p.434-

;particle locations are chosen randomly, and each subsequent
;particle is accepted if it does not overlapp with any previous one
;also overlaps accross borders are checked
; --> may take a while!

;Note: the vertical thickness of the layer 
;used in the calculation of D is that of the particle centers

;--------------------------------------------------------------
;What needs to be specified is 
;N, TAU, D
;name of posdat-file
;comment to be included to posdat file

;Just modify the example below:

;--------------------------------------
;a single posdat-file
;--------------------------------------
;April 10, 2001

N=100
TAU=0.5
D=0.1
posdat_file='../POSDAT/d100_tau05_small.posdat19'
comment='TAU=0.5, D=0.100 N=100 small' 
;--------------------------------------






    ylfac=1.                    ;yl/xl tangential/radial extend
    xlyl=N*!pi/4./TAU
    xl=sqrt(xlyl/ylfac)
    yl=ylfac*xl
    
    
    zl=!pi/6.*N/xl/yl/d
    
    print,posdat_file
    print,comment
    print,'tau=',n*!pi/4/xl/yl
    print,'D=  ',n*4.*!pi/3./(8.*xl*yl*zl)
    print,'xl,zl',xl,zl

    xx=fltarr(n)
    yy=xx
    zz=xx
    ss=xx+1.
    dx=2.*xl
    dy=2.*yl
    dz=2.*zl
    
    iover=0
    for i=0l,n-1 do begin
        if i mod 1000 eq 0 then print,i
new_try:
        xx(i)=randomu(seed)*dx-xl
        yy(i)=randomu(seed)*dy-yl
        zz(i)=randomu(seed)*dz-zl
        
        if(i ge 1) then begin
            ind=lindgen(i)
            distx=abs(xx(i)-xx(ind))
            disty=abs(yy(i)-yy(ind))
            distz=abs(zz(i)-zz(ind))
            
            index=where(distx gt xl,count)
            if(count ge 1) then distx(index)=2*xl-distx(index)
            
            index=where(disty gt yl,count)
            if(count ge 1) then disty(index)=2*yl-disty(index)
            
            dist2=distx^2+disty^2+distz^2
            if(min(dist2) lt 4.) then begin
;print,'overlap',i
                iover=iover+1
                if iover mod 5000 eq 0 then print,'iover,i',iover,i
                goto, new_try
            endif
            
        endif                   ;i ge 1
    endfor


    print,'iover=',iover
    slice,xx,yy,zz,ss,zs=0,xl=xl,yl=yl,/nopl

    dummy=0.
    close,1
    openw,1,posdat_file
    printf,1,posdat_file
    printf,1,comment+' zl= '+string(max(zz))
    printf,1,dummy,xl,yl,dummy,format='(4f16.8)'
    printf,1,n
    for i=0l,n-1 do begin
        printf,1,ss(i),xx(i),yy(i),zz(i)
    endfor
    close,1

    posfile=posdat_file+'.save'
    save,file=posfile,posdat_file,comment,xx,yy,zz,ss,xl,yl,zl,n,tau,d

    print,'posdat:',posdat_file
    print,'save:',posfile


end







