;---------------------------------------------
pro albedo,testm,testa,albedo,pr0=pr0
;---------------------------------------------

if(n_params() le 0) then begin
    print,'albedo,testm,testa,A'
    print,'testm-table for MC-simulation:
    print,'     testm(n_orders)     -> testa for alb=A  (ndim=1)'
    print,'     testm(arg,n_orders) -> testa(arg) for alb=A  (ndim=2)'
    print,'pr=values                -> ss-albedo=pr  (def: pr=A)'
    print,'example: just SS -> set A=1d-8, pr=1'
    print,'example: just MS -> set A=alb,  pr=1d-8'
    print,'HS 070803: checks actual max order of scattering'
    return
endif

alb=albedo
pr=albedo
if(keyword_set(pr0)) then pr=pr0

ndim=size(testm,/n_dim)

if(ndim ge 2) then begin
    n_orders=n_elements(testm(0,*))
    testa=testm(*,0)*pr
    for i=1,n_orders-2 do begin
        testa=testa+alb^(i+1.)*testm(*,i)
    endfor
endif

if(ndim eq 1) then begin
    n_orders=n_elements(testm)
    testa=testm(0)*pr
    for i=1,n_orders-2 do begin
        testa=testa+alb^(i+1.)*testm(i)
    endfor
endif

end
