c-------------------------------------------------------------------
c     renamed to mc_oppo_image_160506.for 160506
c                (more comments added)
c     renamed to mc_oppo_image_030206.for 030206
c     renamed to mc2004_oppo.for 130804

c-------------------------------------------------------------------
c    IMAGE additions (2005)
c     _image - contains debugging of photon-paths
c               + creation of test-image

c    SPOKE additions (2004)
c    _2pos  - reads two separate pos-files:  particles /haze
c             uses different phase functions for these populations
c             marked by variable part_type = 1 or 2 

c     CODE_TO_DONES/mcnewd_oppo.for
c     copied to MCCODE/CODE in halla 26.2.2003
c     added intepretation of fiiobs
c     fiilat, fiiobs tables if ntest negative


c****************************************************************
      program mc_oppo
c****************************************************************

c     driver for calculating the photometric properties of 
c     a single particle position-file and a fixed sun direction
c     BSUN, FIISUN

c     viewed from a single or several observing directions, 
c     specified by a fixed observing latitude/various phase-angles
c        BSUN, BOBS, alpha   -> FIIOBS-FIISUN

c     alternatively: give observing BOBS and FIIOBS-FIISUN
c                    instead of BOBS, alpha
c     indicated by alpha > 1000-180.  -> FIIOBS=alpha-1000.+FIISUN

c     uses the subroutine 
c     mcnew_sub_2pos_image.for for the calculation of scattering
     
c     output of results via wfile created in mcnewd_sub._2pos_image.for
c     use mc_wread_2pos_f.pro for reading this output

c****************************************************************

c     HS 7/12/99 - 04/01/02 - 160506

      implicit double precision (a-h,o-z)   
      include 'mc2004_main.inc'

      parameter(nnt=100)
      character(len=80) posfile,parfile,outfile,epsfile,wfile
      double precision testfii(nnt),testlat(nnt)
      double precision testw(nnt),testd(nnt),testn(nnt)
      double precision testm(nnt,50)
      double precision lonsun,mu0
      double precision iscat_mean,npot_mean,nbox_mean
      double precision testfiitab(nnt),testlattab(nnt)


c---------------------------------------
c _2pos additions:
c---------------------------------------
c     posfile_haze = posdat-file containing haze particles
c     smet_haze    = describtion of haze phase function
c     method_haze
c     ppar1_haze, ppar2_haze, ppar3_haze

      character(len=80) posfile_haze
      character(len=30) smet_haze
      double precision testm_2pos(nnt,0:20,0:50)

c---------------------------------------
c  mc2004 additions
c---------------------------------------
c     imagefile   = image + debugging named after this
c     nxpix,nypix = size of image

c     idebug    -> debug

c     iemulate  -  emulate errors in old versions
c               = 0  no 
c               = 1  inidist
c               = 2  no retbox
c               = 3  both

c     irot      = 0 do not rotate particle field
c               = 1  

c     isquare   = 0 random initial photons
c                 1 regular grid:  

c---------------------------------------

      character(len=80) imagefile
      character(len=8) date
      character(len=10) time
      character(len=5) zone
      integer*4 values(8)
      character(len=30) smet,smodel
      double precision ar,ra,apu1,apu2,apu3,apu4

      ar=0.01745329251994329547d0
      ra=1.d0/ar

c     posfile    = posdat-file containing particle positions
c     parfile    = parameter-file (junk -> use defaults)
c     outfile    = output of indirect MC weights + directions   (junk)
c     epsfile    = output of indirect MC weights + fiilat-table (junk)
c     wfile      = output of indirect MC weights

c     sredu = reduction factor for particle radius      (sredu < 1)
c     zredu = reduction factor for vertical coordinates (zredu > 1)
c     idum  = seed 


c********************************************************
c     READ INPUT VALUES
c********************************************************

c     particle positions from POSFILE
c     BSUN,LONSUN  = elevation and longitude of sun  
c        (would have been better to call bsun,fiisun)
c     TESTLAT,TESTFII = table of observer directions  
c         ( -"-                           bobs,fiiobs)

c     OUTPUT:
c     testw,testn,testd,testm
c     to convert testw to I/F:
c     multiply by sin(bsun)/nphot/sin(bobs)
c     (see the comment in mc_sub_image.for, subroutine INDIRECT)


      read(*,*)   posfile
      read(*,*)   bsun,lonsun
      read(*,*)   ntest

c-------------------------------------------------
c     two choices for intepretation of input variable 'testfii':

c     1) input testfii < 1000.-180 --->
c        testfii intepreted as alpha --> calculate dlobs from
c          cos_alpha=cos(dlobs*ar)*cos(bsun*ar)*cos(bobs*ar)+
c                sin(ar*bobs)*sin(bsun*ar)

c     2) input testfii > 1000.-180. --->
c        dlobs=testfii-1000.

c     After this construct the actually used testfii:
c     testfii= lonsun+dlobs    (dlobs corresponds to fiiobs-fiisun)

c-------------------------------------------------
c     two choices for ntest: 
c     1)  ntest positive -> read a list of testlat,testfii values
c     2)  ntest negative -> read arrays of testlat,testfii and
c                           take all combinations


      if(ntest.gt.0) then
         do 5 i=1,ntest
            read(*,*) testlat(i),testfii(i)
 5       continue
      endif

      if(ntest.lt.0) then
         read(*,*) nlat,nfii
         do 6 i=1,nlat
            read(*,*) testlattab(i)
 6       continue
         do 7 i=1,nfii
            read(*,*) testfiitab(i)
 7       continue
         ntest=nfii*nlat
         lask=0
         do 8 i=1,nfii
            do 9 j=1,nlat
               lask=lask+1
               testlat(lask)=testlattab(j)
               testfii(lask)=testfiitab(i)
 9          continue
 8       continue
      endif   


      do 10 i=1,ntest
         apu=testfii(i)
         if(apu.lt.820.) then
            apu1=dcos(testfii(i)*ar)-dsin(ar*bsun)*dsin(ar*testlat(i))
            apu2=dcos(ar*bsun)*dcos(ar*testlat(i))
            apu3=apu1/apu2
            apu4=apu3
            apu3=dacos(apu3)*ra
            if(abs(testfii(i)).le.1d-6) apu3=0.d0
         endif
         if(apu.ge.820.) then
            apu3=apu-1000.d0
            cos_alpha=cos(apu3*ar)*cos(bsun*ar)*cos(testlat(i)*ar)+
     +           sin(ar*testlat(i))*sin(bsun*ar)
            apu=acos(cos_alpha)*ra
         endif
         testfii(i)=lonsun+apu3
         write(*,820) 'lat,fii,alpha',testlat(i),testfii(i),apu
 10   continue

 820  format(a16,2f8.3,f12.6)

c-------------------------------------------------------------------

      read(*,*)   nxphot,nyphot,mx,my
      write(*,*)  nxphot,nyphot,mx,my
      read(*,*)   parfile
      read(*,*)   outfile
      read(*,*)   epsfile
      read(*,*)   wfile
      read(*,*)   method

      smet='unknown'
      if(method.eq.1 )   smet='LAMBERT-element '
      if(method.eq.11)   smet='LAMBERT-sphere-center  '
      if(method.eq.12)   smet='LAMBERT-sphere-point  '
      if(method.eq.2 )   smet='ISOTROPIC-sphere'
      if(method.eq.3 )   smet='HG-sphere-center'  
      if(method.eq.4 )   smet='HG-sphere-point'  
      if(method.eq.13)   smet='HG2-sphere-center'  
      if(method.eq.14)   smet='HG2-sphere-point'  
      if(method.eq.5 )   smet='EULER-sphere-center'  
      if(method.eq.6 )   smet='EULER-sphere-point'  
      if(method.eq.7 )   smet='CALLISTO-sphere-center'  
      if(method.eq.8 )   smet='CALLISTO-sphere-point'  
      if(method.eq.9 )   smet='POWER-sphere-center'  
      if(method.eq.10)   smet='POWER-sphere-point'  
      if(method.eq.15)   smet='TABLE-sphere-center'  
      if(method.eq.16)   smet='TABLE-sphere-point'  

      read(*,*) ppar1,ppar2,ppar3

c---------------------------------------
c _2pos additions:
c---------------------------------------

      read(*,*)   posfile_haze
      read(*,*)   method_haze

      smet_haze='unknown'
      if(method_haze.eq.1 )   smet_haze='LAMBERT-element '
      if(method_haze.eq.11)   smet_haze='LAMBERT-sphere-center  '
      if(method_haze.eq.12)   smet_haze='LAMBERT-sphere-point  '
      if(method_haze.eq.2 )   smet_haze='ISOTROPIC-sphere'
      if(method_haze.eq.3 )   smet_haze='HG-sphere-center'  
      if(method_haze.eq.4 )   smet_haze='HG-sphere-point'  
      if(method_haze.eq.13)   smet_haze='HG2-sphere-center'  
      if(method_haze.eq.14)   smet_haze='HG2-sphere-point'  
      if(method_haze.eq.5 )   smet_haze='EULER-sphere-center'  
      if(method_haze.eq.6 )   smet_haze='EULER-sphere-point'  
      if(method_haze.eq.7 )   smet_haze='CALLISTO-sphere-center'  
      if(method_haze.eq.8 )   smet_haze='CALLISTO-sphere-point'  
      if(method_haze.eq.9 )   smet_haze='POWER-sphere-center'  
      if(method_haze.eq.10)   smet_haze='POWER-sphere-point'  
      if(method_haze.eq.15)   smet_haze='TABLE-sphere-center'  
      if(method_haze.eq.16)   smet_haze='TABLE-sphere-point'  

      read(*,*) ppar1_haze,ppar2_haze,ppar3_haze

c need also single scattering albedos for particles and haze

      read(*,*) ssca_part, ssca_haze
c---------------------------------------

c     icheck=-1 -> no check output
      read(*,*)   icheck
      read(*,*)   idum
      read(*,*)   sredu,zredu
      read(*,*)   sizemin
      read(*,*)   s20,f20

c-----------------------------------------
c     Saturn-shine:
c     iglobe=0 -> SUN
c     iglobe=1 -> SATURN
c     iglobe=2 -> SATURN-SOUTH
c     iglobe=3 -> SATURN-NORTH
c     abox = calculation distance
c     rsaturn = Saturn radius
c     nlat_sat = number of latitude bins
c     nfii_sat = number of longitude bins
c     model_sat = saturn model
c               = 1 -> Lambert 
c               = 2 -> RED (DONES ET ALL)
c               = 3 -> BLUE (DONES ET ALL)

      rsaturn=60.4
      read(*,*)   iglobe
      read(*,*)   abox
      read(*,*)   nlat_sat,nfii_sat
      read(*,*)   model_sat


c-------------------------------------------------------------
c     irot=1        particle field rotated between photons
c     irot=0        particle field not rotated

      read(*,*)     irot

c-------------------------------------------------------------
c     isquare=0     shoot photons randomly
c     isquare=1     shoot photons on a regular grid

      read(*,*)     isquare

c-------------------------------------------------------------
c     imagefile     make a nxpix*nypix image of the system 
c                   stored to imagefile.TESTIMAGE 
c                   IF nxpix=0 -> do not make image                    
                    
      read(*,*)     imagefile
      read(*,*)     nxpix,nypix

c-------------------------------------------------------------
c     idebug        debug variable
      read(*,*)     idebug

c     iemulate errors
      read(*,*)     iemulate

c-------------------------------------------------------------


      if(model_sat.eq.1) smodel='Lambert-planet'
      if(model_sat.eq.2) smodel='RED  0.5*zones+0.5*belts'   
      if(model_sat.eq.3) smodel='BLUE 0.5*zones+0.5*belts'
      if(model_sat.eq.4) smodel='RED+BLUE 0.5*zones+0.5*belts'
      if(model_sat.eq.5) smodel='ZONES 0.75*blue+0.25*red' 
      if(model_sat.eq.6) smodel='BELTS 0.75*blue+0.25*red'

      write(*,*) '=========================================='
      write(*,*) 'SPOKES2004/VER2/mcnewd_oppo_2pos.for (27.07.2004)'
      call date_and_time (date, time, zone, values)
      write(*,999) values(1),values(2),values(3),values(5),values(6)
 999  format(1x,i4,'-',i2,'-',i2,2x,i2,':',i2,':',i2)
      write(*,*) '=========================================='

      write(*,*) 'POSFILE=     ',posfile
      write(*,*) 'BSUN, LONSUN=',bsun,lonsun 
      write(*,*) 'NTEST        ',ntest
      write(*,*) 'NPHOT,MX,MY= ',nphot,mx,my

      write(*,*) 'PARTICLES:'
      write(*,*) ' POSFILE=    ',posfile
      write(*,*) ' METHOD    = ',method,'  ',smet
      write(*,*) ' PPAR 1,2,3= ',ppar1,ppar2,ppar3
      write(*,*) ' SSCA      = ',ssca_part

      write(*,*) 'HAZE:     '
      write(*,*) ' POSFILE=    ',posfile_haze
      write(*,*) ' METHOD    = ',method_haze,'  ',smet_haze
      write(*,*) ' PPAR 1,2,3= ',ppar1_haze,ppar2_haze,ppar3_haze
      write(*,*) ' SSCA      = ',ssca_haze

      write(*,*) 'SEED       = ',idum
      write(*,*) 'parfile,outfile,epsfile,wfile='
      write(*,*)  '-> ',parfile
      write(*,*)  '-> ',outfile
      write(*,*)  '-> ',epsfile
      write(*,*)  '-> ',wfile
      write(*,*)  'sredu,zredu',sredu,zredu
      write(*,*)  'sizemin ',sizemin
      write(*,*)  's20,f20 ',s20,f20

      if(iglobe.eq.0) write(*,*) 'ILLUMINATION BY SUN'
      if(iglobe.eq.1) write(*,*) 'ILLUMINATION BY SATURN'
      if(iglobe.eq.2) write(*,*) 'ILLUMINATION BY SATURN-SOUTH'
      if(iglobe.eq.3) write(*,*) 'ILLUMINATION BY SATURN-NORTH'
      if(iglobe.ge.1) then
         write(*,*)  'MODEL_SAT=',model_sat,smodel   
         write(*,*)  'DISTANCE =',abox,abox/rsaturn
         write(*,*)  'NLAT,NFII=',nlat_sat,nfii_sat
      endif
      write(*,*) 'FIIOBS intepreted as alpha (unless fiiobs > 180)'
      write(*,*) '50 orders of scattering stored'
      write(*,*) '=========================================='


      write(*,*)  'irot=    ',irot     ,'(1-rot, 0-no)'
      if(irot.eq.1) write(*,*) 'particle field rotated randomly'

      write(*,*)  'isquare= ',isquare  ,'(1-grid, 0-rnd)'
      if(isquare.eq.1) then
         nphots=sqrt(1.d0*nphot)
         nphot=nphots*nphots
         write(*,*) 'isquare=1 -> new nphot=',nphot
      endif

      if(isquare.ge.10) then
         nphots=isquare
         nphot=nphots*nphots
         write(*,*) 'isquare=>10 -> new nphot=',nphot
      endif

      write(*,*)  'idebug=  ',idebug    
      write(*,*)  'iemulate=',iemulate
      write(*,*)  'testimage= ',imagefile
      write(*,*)  'nxpix,nypix   = ',nxpix,nypix
      write(*,*)  'nxphot,nyphot = ',nxphot,nyphot


            sunfii=lonsun
            sunlat=bsun

c     Saturn-shine?

            nphot_tod=nphot
            flux_sat=0.
            if(iglobe.ge.1) then
               call saturn_illumination
     +              (sunlat,sunfii,nphot_ori,nphot_tod,flux_sat)
               nphot=nphot_tod
            endif
            write(*,*) 'flux_sat,nphot',flux_sat,nphot


c     MC-calculation

            call tim(cpu1)
            call mcnew_sub_2pos_image(nxphot,nyphot,
     +           posfile,parfile,outfile,
     +           sunfii,sunlat,
     +           ntest,testfii,testlat,testw,testd,testn,testm,
     +           idum,icheck,mx,my,
     +           npart,npartori,npot_mean,nbox_mean,iscat_mean,
     +           method,epsfile,wfile,sredu,tau,ndirect,
     +           zredu,ppar1,ppar2,ppar3,
     +           posfile_haze,method_haze,ssca_part,ssca_haze,
     +           ppar1_haze,ppar2_haze,ppar3_haze,testm_2pos,
     +           irot,isquare,idebug,iemulate,imagefile,nxpix,nypix)  

            call tim(cpu2)
            
            mu0=cos((90.-sunlat)*0.017453293)
            fdirect=1.d0*ndirect/nphot
            tau_path=9999.
            tau_n=9999.
            if(fdirect.gt.1d-40) then
               tau_path=-log(fdirect+1.d-43)
               tau_n=tau_path*mu0
            endif

            cpu_comp=(cpu2-cpu1)/(1.*nphot/1000.)
            write(*,*) 'NORI,TAU  = ',npartori,tau
            write(*,*) 'SREDU, ZREDU = ', sredu,zredu
            write(*,*) 'cpu, cpu_comp',cpu2-cpu1,cpu_comp
            write(*,*) 'npart,npot,nbox,iscat',
     +      npart,npot_mean,nbox_mean,iscat_mean
            write(*,*) 'fdir,mu0,tau_p,tau_n',
     +      fdirect,mu0,tau_path,tau_n
            write(*,*) 'sizemin ',sizemin
            write(*,*) 's20,f20 ',s20,f20

      write(*,*) '=========================================='
      call date_and_time (date, time, zone, values)
      write(*,999) values(1),values(2),values(3),values(5),values(6)
      write(*,*) '=========================================='
         end










