c*************************************************************
c
c	mc2004_sub.inc   HS 170506
c	include file for mc_sub_image_size160506
c
c**************************************************************

        implicit double precision (a-h,o-z)

c**************************************************************
c     MAXIMUM SIZE OF ARRAYS IN MC CALCULATION 
c       (I/F in different directions)

c	nn = maximum number of particles (including the duplicates)
c	nnp = maximum number of incoming photons
c	nnt = maximum number of test (=viewing) directions
c	mmx,mmy = maximum number of subdivision in tab-routines
c                 (used in spatial partitioning) 

         parameter(nn=400000)
         parameter(nnp=1000000)
         parameter(nnt=100)
         parameter(mmx=400,mmy=400)
         parameter(mmm=mmx*mmy)


c     MAXIMUM SIZE OF ARRAYS IN STORING OF TESTIMAGE:

c       nnxpix = max x-dimension of test_image
c       nnypix = max y-dimension of test_image
c       nnmpix = max number of scattering orders stored for test_image
c       nntpix = max number of viewing directions in test_image

         parameter(nnxpix=1024,nnypix=1024)	
         parameter(nnmpix=10,nntpix=1)       

c     SOME CONSTANTS:
 
         parameter (pii=3.14159265358979312D0)
         parameter (pii2=2.d0*pii)
         parameter (ar=pii/180.d0,ra=180.d0/pii)
	

c**************************************************************
c      xx,yy,zz,ss = particle coordinates, radius, ss2=ss*ss
c      ly,lx       = radial and tangential size of the calculation area
c      zmin,zmax   = maximum vertical extent (includes particle size) 

         dimension xx(nn),yy(nn),zz(nn),ss(nn),ss2(nn)
         double precision ly,lx
         common /com1/ xx,yy,zz,ss,ss2
         common /com2/ xl,yl,sy,ly,lx,zmin,zmax
         common /com3/ npart,ntest,nbox,icheck,nboxvis,npartori
         common /com4/ ssca,w


c**************************************************************
c      direct MC: direction, weight, number of scatterings
c                 for escaping photoms

         real lattab(nnp),fiitab(nnp),wtab(nnp),scatab(nnp)
         common /com5/ lattab,fiitab,wtab,scatab

c**************************************************************
c      indirect MC: wieving directions 

         dimension extest(nnt),eytest(nnt),eztest(nnt)
         common /com6/ extest,eytest,eztest

c      indirect MC: weight in viewing directions
	
         dimension testw(nnt),testd(nnt),testn(nnt),testm(nnt,50)
         common /com7/ testw,testd,testn
         common /com8/ testm

c      variables related to spatial partitioning

         dimension indtab(nn),numtab(mmm),mintab(mmm)
         dimension dtab(mmm), cxtab(mmm), cytab(mmm),dtab2(mmm)
         common /com9/indtab,numtab,mintab
         common /com10/cxtab,cytab,dtab,dtab2
         common /com11/mx,my,npot_sum,npot_lkm,nbox_lkm,nbox_sum

c      misc

         common /com12/ ipart_now,method
         common /com13/ sredu,zredu,tau
         dimension testd_apu0(nnt)
         common /com14/ testd_apu0

c       addition jan2001 9.01.2001
         common /com15/ppar1,ppar2,ppar3
         common /com16/exold,eyold,ezold



c       variables related to Dones et al. 1993 power-law 
c       phase-function, used in tabulated form

         parameter(nntables=10001)
         dimension power_inte(nntables),power_alpha(nntables)
         dimension power_dinte(nntables)
         common /com_power1/ power_inte, power_alpha, power_dinte
         common /com_power2/ power_expo,c_n


c	variables related to arbitrary tabulated phase-function
c	mcphase_alpha = alpha
c	mcphase_phase = phase(alpha)
c	mcphase_inte =  int{phase(alpha)}

          double precision mcphase_alpha(nntables)
          double precision mcphase_phase(nntables)
          double precision mcphase_dphase(nntables)
          double precision mcphase_inte(nntables)
          double precision mcphase_dinte(nntables)

          common /com_mcphase1/ mcphase_alpha,mcphase_phase,
     +    mcphase_dphase,mcphase_inte,mcphase_dinte
          common /com_mcphase2/ n_alpha


c**************************************************************
c       VARIABLES RELATED TO HAZE (SPOKES 2004)

c       part_type = 1 (particle)   2 (haze)
c       ssca_part = ssca particles
c       ssca_haze = ssca haze

          integer part_type(nn)
          common /com_haze1/ part_type
          common /com_haze2/ method_haze
          common /com_haze3/ ssca_part,ssca_haze
          common /com15_haze/ ppar1_haze,ppar2_haze,ppar3_haze

c	for tabulated phase-function: haze
c	mcphase_alpha_haze = alpha
c	mcphase_phase_haze = phase(alpha)
c	mcphase_inte_haze =  int{phase(alpha)}

          double precision mcphase_alpha_haze(nntables)
          double precision mcphase_phase_haze(nntables)
          double precision mcphase_dphase_haze(nntables)
          double precision mcphase_inte_haze(nntables)
          double precision mcphase_dinte_haze(nntables)

          common /com_mcphase1_haze/ mcphase_alpha_haze,
     +    mcphase_phase_haze, mcphase_dphase_haze,
     +    mcphase_inte_haze,mcphase_dinte_haze
          common /com_mcphase2_haze/ n_alpha_haze

c       tabulation  

          dimension testm_2pos(nnt,0:20,0:50)
          common /com8_haze/ testm_2pos
          common /com9_haze/ iscat_part,iscat_haze


c--------------------------------------------------------------------
c      debug paths  for debug.pro 
c--------------------------------------------------------------------
 
	  common /debug1/ iphot_mui,iscat_mui,ibox_mui,idebug

c--------------------------------------------------------------------
c      test_image
c--------------------------------------------------------------------

          integer ill_image(nnxpix,nnypix)
          integer vis_image(nnxpix,nnypix,1)
          real x_image(nnxpix,nnypix)
          real y_image(nnxpix,nnypix)
          real test_image(nnxpix,nnypix,nnmpix,nntpix)

          common /imagecom1/ test_image
          common /imagecom11/ vis_image,ill_image
          common /imagecom2/ npix,ixphot,iyphot
          common /imagecom3/ x_image,y_image

          character(len=80) imagefile
          common /aug2004a/ ierror1,ierror2
          common /aug2004b/ imagefile
          common /nov2004a/ nxpix,nypix,nxphot,nyphot

c there was a bug in testimage!
c ill and vis were stored with ixphot,iyphot...

          common /feb2006a/ ixpix,iypix,nntpix_use

c--------------------------------------------------------------------