;---------------------------------------------------------------
  pro pii_kolikko_f,N,RL,pii,rel_teo,print=print
;---------------------------------------------------------------
;esimerkki pii:n arvioimiseksi kolikkoa heittamalla
;--------------------------------------------------------------
;Heitetaan kolikkoa, jonka halkaisija on 2R, 
;ruudukolle jonka ruutujen koko on 2L  (oletetaan 2R < 2L)
;Merkitaan kolikon keskipisteen paikkaa x,y 
;(mitattuna mielivaltaisesta ruudukon leikkauspisteesta)
;Milla todennakoisyydella kolikko peittaa yhden ruudukon
;leikkauskohdista = hit?
;--------------------------------------------------------------
;symmetria -> voidaan tarkastella aluetta
;             0<x<L, 0<y<L
;mikali       x^2+y^2 < R^2 -> peittaa ruudukon leikkauskohdan

;arvio todennakoisyydelle =  N_hit/N
;jossa N on kaikkien heittojen lukumaara ja N_hit 'osumien maara'

;teoreettisesti tiedetaan etta odotusarvo=
;kolikon ala/ruudun ala  = pi/4 (R/L)^2

; --> arvio pii= 4*(L/R)^2 N_hit/N
;--------------------------------------------------------------
;aliohjelma-versio, ohjeet kaytosta:
    if(n_params() le 0) then begin
       print,'pii_kolikko_f,N,RL,pii,rel_teo'
       print,'lasketaan pii:n arvo kolikkoa heittamalla'
       print,'INPUT:    '
       print,'          N= heittojen lukumaara'
       print,'          RL= R/L  rahan lapimitta/ryydun koko'
       print,'OUTPUT:   '
       print,'          PII = arvio pi:lle'
       print,'          rel_teo = teoreettinen arvio suhteelliselle virheelle'
       print,'KEYWORDS:'
       print,'          /print -> tulosta'
       return
    endif
;--------------------------------------------------------------
;   N=1000             ;heittojen lukumaara 
   x=randomu(seed,N)
   y=randomu(seed,N)
;   RL=0.8                       ;kolikon sade R/L
   R2=RL^2
   
   hit=where((x^2+y^2) le R2, N_hit)
   pii=4./R2*N_hit/N

;teoreettinen virhearvio
;osumistodennakoisyys p= pi/4 (R/L)^2 kussakin heitossa
;Riippumattomat heitot, binomitodennakoisyys -->
;sigma_p_teo=sqrt(p(1-p)/N)

   p= !pi/4 * (RL)^2
   sigma_p_teo=sqrt(p*(1-p)/N)

;arvio pii= 4*(L/R)^2 p -> dpii/pii= dp/p
;suhteellinen virhe rel_teo=sigma_p_teo/p

   rel_teo=sigma_p_teo/p
   if(keyword_set(print)) then begin
      print,'N,R/L, PII/pi dpii/pi=',N,RL,pii/!pi,rel_teo
   endif
end
