;------------------------------------------------------------------
program='pii_kolikko_driver'
ps=2
psdirect,program,ps                         ;avaa ps-tulostuksen
;------------------------------------------------------------------
!p.multi=[0,2,1]
  nwin

  ntab=[1d1,1d2,1d3,1d4,1d5,1d6] ;heittojen määrä yhdessä heittokokeessa
  k=30                           ;kutakin heittokoetta k:n sarja   
  nn=n_elements(ntab)
  piitab=fltarr(nn,k)           ;taltioidaan jokaisen heittokokeen tulos
  piitab_mean=fltarr(nn)        ;keskiarvo kullekin N
  errtab_teo=fltarr(nn)         ;teoreettinen keskivirhe kullekin N
  errtab_obs=fltarr(nn)         ;havaittu keskivirhe kullekin N
  rl=1.

  plot,ntab,ntab*0.+!pi,/xlog,xtitle='N',ytitle='PII',$
       xr=[1,1e7],yr=[2,4],xs=1,title='pii_kolikko_driver.pro  R/L=1.'

  for in=0,nn-1 do begin
     n=ntab(in)
     for ik=0,k-1 do begin
        pii_kolikko_f,n,rl,pii,rel_err
        piitab(in,ik)=pii
        plots,n,pii,psym=6,syms=0.2
        if(ik eq 0) then errtab_teo(in)=rel_err*!pi
     endfor
     errtab_obs(in)=stdev(piitab(in,*)) ;otoshajonta
     piitab_mean(in)=mean(piitab(in,*)) ;keskiarvo
  endfor
  
  oplot,ntab,piitab_mean,lines=2
  oplot,ntab,piitab_mean+errtab_obs,lines=2
  oplot,ntab,piitab_mean-errtab_obs,lines=2  
  oplot,ntab,!pi+errtab_teo,lines=0,col=2
  oplot,ntab,!pi-errtab_teo,lines=0,col=2

  nwin
   plot,ntab,errtab_teo/!pi,/xlog,/ylog,xtitle='N',ytitle='rel error',$
       xr=[1,1e7],yr=[1d-4,1],xs=1,title='pii_kolikko_driver.pro  R/L=1.' 
   oplot,ntab,errtab_obs/!pi,lines=2,psym=-6
;-------------------------------------------------------------------------
psdirect,program,ps,/stop
!p.multi=0
end
