
;---------------------------------------------------------------
;pii_kolikko.pro
;esimerkki pii:n arvioimiseksi kolikkoa heittamalla
;--------------------------------------------------------------
;Heitetaan kolikkoa, jonka halkaisija on 2R, 
;ruudukolle jonka ruutujen koko on 2L  (oletetaan 2R < 2L)
;Merkitaan kolikon keskipisteen paikkaa x,y 
;(mitattuna mielivaltaisesta ruudukon leikkauspisteesta)
;Milla todennakoisyydella kolikko peittaa yhden ruudukon
;leikkauskohdista = hit?
;--------------------------------------------------------------
;symmetria -> voidaan tarkastella aluetta
;             0<x<L, 0<y<L
;mikali       x^2+y^2 < R^2 -> peittaa ruudukon leikkauskohdan

;arvio todennakoisyydelle =  N_hit/N
;jossa N on kaikkien heittojen lukumaara ja N_hit 'osumien maara'

;teoreettisesti tiedetaan etta odotusarvo=
;kolikon ala/ruudun ala  = pi/4 (R/L)^2

; --> arvio pii= 4*(L/R)^2 N_hit/N
;--------------------------------------------------------------

   N=1000             ;heittojen lukumaara 
   x=randomu(seed,N)
   y=randomu(seed,N)
   RL=1.0                       ;kolikon sade R/L
   R2=RL^2
   
   hit=where((x^2+y^2) le R2, N_hit)

;HUOM: oltava tarkkana IDL tyyppimaarittelyjen kasittelyn suhteen:
;Mika olisi tulos jos kirjoittaisit 4. (=float) sijasta 4 (=integer)?
;arvio pi:n arvolle = pii

   pii=4.*N_hit/N*1./R2

;teoreettinen virhearvio
;osumistodennakoisyys p= pi/4 (R/L)^2 kussakin heitossa
;Riippumattomat heitot, binomitodennakoisyys -->
;sigma_p_teo=sqrt(p(1-p)/N)

   p= !pi/4 * (RL)^2
   sigma_p_teo=sqrt(p*(1-p)/N)

;arvio pii= 4*(L/R)^2 p -> dpii/pii= dp/p
;suhteellinen virhe rel_teo=sigma_p_teo/p

   rel_teo=sigma_p_teo/p
   print,'N,R/L, PII/pi dpii/pi=',N,RL,pii/!pi,rel_teo


;------------------------------------------------------------
;piirretty selostuksessa oleva kuva:
   iplot=0
   if(iplot eq 1) then begin
      nwin
      plot,[0,0],[0,0],xr=[-2.5,3.5],yr=[-2.5,3.5],xs=1,ys=1,/iso,$
           title='kolikon sade R/L='+string(rl,'(f6.2)')
      for i=-2,2,2 do begin
         oplot,i*[1,1],[-3,4],lines=1
         oplot,[-3,4],i*[1,1],lines=1
      endfor
      oplot,[0,1,1,0,0],[0,0,1,1,0],lines=2
      oplot,[0,2,2,0,0],[0,0,2,2,0],thick=2      
      fii=findgen(101)/100.*2*!pi
      oplot,cos(fii)*rl,sin(fii)*rl,thick=2,lines=2
      oplot,x(hit),y(hit),psym=3      
   endif

end
