

program='mc_sini'
ps=0
psdirect,program,ps,/col



;---------------------------------------------
;integraali sin(x)  0 - \pi
;teoreettinen:  sijoitus -cos(x)  =   cos(0)-cos(\pi)=2
   int0=2.

   N=100
   x=randomu(seed,N)*!pi
   c=1.                         ;rajaa sin(x)
   y=randomu(seed,N)*c
   
;Menetelma 1 - keskiarvo
   f=sin(x)
   int1=mean(f)*!pi
;Menetelma 2 - hit or miss
   ind=where(y le sin(x),n_hit)
   int2=c*!pi*n_hit/n
     
;teoreettiset virhearviot
;menetelma 1:
;varianssi*N = (b-a)* integraali f^2(x) dx -(integraali f(x)dx)^2
   vari1= !pi* !pi/2. -2^2
   
;menetelma 2:
;varianssi*N = c*(b-a)integraali f^(x) dx -(integraali f(x)dx)^2   
   vari2=1*!pi*2-2*2
  
   print,'N,int0,dint1,int2',n,int0,int1,int2 
   print,sqrt(vari1/n),sqrt(vari2/n)
   
;------------------------------------------------------------
;katsotaan miten tulokset jakaantuvat kun lasketaan k kertaa
;kayttaen eri satunnaisotosta

   k=1000
   int1tab=fltarr(k)
   int2tab=fltarr(k)

   for ik=0,k-1 do begin
      N=1000
      x=randomu(seed,N)*!pi
      c=1.                      ;rajaa sin(x)
      y=randomu(seed,N)*c   
;Menetelma 1 - keskiarvo
      f=sin(x)
      int1=mean(f)*!pi
;Menetelma 2 - hit or miss
      ind=where(y le sin(x),n_hit)
      int2=c*!pi*n_hit/n
      
      int1tab(ik)=int1
      int2tab(ik)=int2
   endfor

;plotataan tulosten jakauma + virhearviota vastaava gaussinen
;jakauma (osoittaa etta KRAL toimii hyvin!)

   nwin
   histo_f,int1tab,1.8,2.2,.01,xx,yy1
   plot,xx,yy1,psym=10,title='sin(x) integroitu 0 - pi, N=1000',/nod
   oplot,xx,yy1,psym=10,col=2,lines=0
   histo_f,int2tab,1.8,2.2,.01,xx,yy2
   oplot,xx,yy2,psym=10,col=3,lines=2
   
   haj1=sqrt(vari1/n)
   oplot,xx,1./(sqrt(2*!pi)*haj1)*exp(-0.5*((xx-int0)/haj1)^2),col=2
   haj2=sqrt(vari2/n)
   oplot,xx,1./(sqrt(2*!pi)*haj2)*exp(-0.5*((xx-int0)/haj2)^2),col=3,lines=2
   
   ff='(f6.3)'
   label_data,0.65,0.9,['Keskiarvo'+string(haj1,ff),'Hit or miss'+string(haj2,ff)],col=[2,3],lines=[0,2],len=0.075
  psdirect,program,ps,/stop
 
   xyouts,1.82,13,'pylvaat=saatujen MC-tulosten jakauma',col=5
   xyouts,1.82,12,'viiva=Normaalijakauma jolla!csama keskivirhe',col=5

end
