program='jakaumat'
ps=0
psdirect,program,ps,/color
;--------------------------------------------------------------
;luodaan jakaumafunktiot
;a) f(y)= 2y               -> F(y)=y^2
;b) f(y)= (k+1)*y^k        -> F(y)=y^(k+1)
;c) f(y)= L*exp(-L*y)      -  F(Y)=1-exp(-L*Y)
;vastaavat kertymafunktiot ja niiden kaanteisfunktiot
;a)  F(y) = y^2 = R         --> y=sqrt(R)
;b)  F(y) = y^(k+1) = R     --> y=r^(1/(k+1))
;c)  F(y) = 1-exp(-L*Y)=R   --> y = -1/L * alog(1-R)  

n=1000
ns='  N='+string(n,'(i8)')
r=randomu(seed,n)

nwin
!p.multi=[0,1,3]
!p.charsize=2
;------------------------------------------------------------------------------
;a)
y=sqrt(R)
yarg=findgen(100)/100.
farg=2*yarg
histo_f,y,0,1,0.01,xx,yy                ;histo_f,x,x1,x2,dx,xx,yy
plot,yarg,farg,xtitle='y',ytitle='f(y)',title='f(y)=2y'+ns
oplot,xx,yy,psym=10,col=2
;------------------------------------------------------------------------------
;b)
k=4
y=R^(1./(1.+k))
yarg=findgen(100)/100.
farg=(k+1)*yarg^k
histo_f,y,0,1,0.01,xx,yy
plot,yarg,farg,xtitle='y',ytitle='f(y)',title='f(y)=(k+1)*y^k, with k='+string(k,'(i4)')+ns
oplot,xx,yy,psym=10,col=2
;------------------------------------------------------------------------------
;c)
L=2.
y=-1./L*alog(1-R)
yarg=findgen(300)/100.*L
farg=L*exp(-L*yarg)
histo_f,y,0,6,0.01,xx,yy
plot,yarg,farg,xtitle='y',ytitle='f(y)',title='f(y)=L*exp(-L*yarg), with L=2'+ns
oplot,xx,yy,psym=10,col=2
;------------------------------------------------------------------------------
psdirect,program,ps,/color,/stop
end



