;---------------------------------------------
;stati2008_synte.pro
;HS 240408
;--------------------------------------------
nr=200
r=(dindgen(nr)+.5)/nr*500

  fbulge=2000.d0
  rbulge=3.d0
  nbulge=2.d0
  fdisk=100.d0
  rdisk=50.d0

  a=dindgen(5)
  a(0)=fbulge
  a(1)=rbulge
  a(2)=nbulge
  a(3)=fdisk
  a(4)=rdisk
  asynte=a

  beta=1.d0/nbulge
  fb=fbulge*exp(-(r/rbulge)^beta)
  fd=fdisk*exp(-r/rdisk)
  f=fb+fd


  sky=1.
  dr=r(1)-r(0)
  npix=2*!pi*r*dr  
  sigma_f=(r*0.+sky+sqrt(f))/sqrt(npix)
  
  seed=1
  fobs=f+randomn(seed,nr)*sigma_f

  nwin
  !p.multi=0
  plot,r,fobs,psym=-6,syms=.4,/ylog,xtitle='radius',ytitle='flux',$
       yr=[1d-2,1d4],title='SYNTE'
  oplot,r,fb+fd,col=5
  oplot,r,fb,col=2,lines=2
  oplot,r,fd,col=3,lines=1

f6='(f8.2)'
  xyouts,0.7,0.90,/nor,'fbukge='+string(fbulge,f6)
  xyouts,0.7,0.84,/nor,'rbulge='+string(rbulge,f6)
  xyouts,0.7,0.78,/nor,'nbulge='+string(nbulge,f6)

  xyouts,0.7,0.70,/nor,'fdisk='+string(fdisk,f6)
  xyouts,0.7,0.64,/nor,'rdisk='+string(rdisk,f6)


  
   save,file='stati2008_synte.save',r,fobs,sigma_f,asynte
end
