;************************************************************
pro stati2008_bd_model,x,a,f,pder,fb=fb,fd=fd,newite=newite
;************************************************************

common stati2008_bd_com,check,fobs,sigma

;SERSIC BULGE + EXPONENTIAL DISK
;***************************************
;total flux(x) = fb(x)+fd(x)

;limit paramaters:

if(a(0) le 0.  ) then a(0)=1.0d-12
if(a(1) le 0.01) then a(1)=0.01d0
if(a(2) le 0.1 ) then a(2)=0.1d0

if(a(3) le 0.  ) then a(3)=1.0d-12
if(a(4) le 1.  ) then a(4)=1.d0

fbulge=a(0)
rbulge=a(1)
nbulge=a(2)
fdisk=a(3)
rdisk=a(4)

beta=1.d0/nbulge
fb=fbulge*exp(-(x/rbulge)^beta)
fd=fdisk*exp(-x/rdisk)
f=fb+fd

;insert here the analytically calculated partial derivatives
if(n_params() ge 5) then begin
   df_dfbulge=0.
   df_drbulge=0.
   df_dnbulge=0.
   df_dfdisk=0.
   df_drdisk=0
   pder=[[df_dfbulge],[df_drbulge],[df_dnbulge],[df_dfdisk],[df_drdisk]]
endif


   if(check eq 1) then begin
      if(keyword_set(newite)) then begin
         plot,x,fobs,psym=-6,syms=.2,/ylog,xtitle='radius',ytitle='flux',$
              yr=[1d-4,1d4],title=title
         oplot,x,fb+fd,col=5
         oplot,x,fb,col=2
         oplot,x,fd,col=3
         f6='(f8.1,f8.3,f8.3,f8.1,f8.1,f12.3)'
         chi2norm=total((f-fobs)^2/sigma^2)/(n_elements(x)-5)
         print,a,chi2norm,f=f6
         vast=''
         read,vast
      endif
   endif




end

