;-----------------------------------------------
;stati20008_bd_fit.pro
;-----------------------------------------------
;example routine for fitting 1d galaxy profiles
;with sersic-bulge + exponential disk
;  total flux(r) = fb(r)+fd(r)
;  bulge   fb(r) = fbulge*exp(-(r/rbulge)^beta))
;  disk    fd(r) = fdisk*exp(-r/rdisk)

;Bulge sersic parameter: nbulge=1./beta
;  typically   1 < nbulge < 4
;  nbulge=1    exponential bulge
;  nbulge=4    deVaucouleurs         
;-----------------------------------------------

;siirretään ylimaaraisia muuttujia mallin laskevaan ohjelmaan
;common-lauseen avulla: fobs ja sigma
;curvefit ei niita tarvitse, mutta niita voi kayttaa tulostuksiin
;check maaraa tulostetaanko

common stati2008_bd_com,check,fobs_com,sigma

;check=1 -> tulostus malli-ohjelmassa

  check=1


;initial guesses
  fbulge=2000.d0
  rbulge=3.d0
  nbulge=2.d0
  fdisk=100.d0
  rdisk=50.d0

  a=dindgen(5)
  a(0)=fbulge
  a(1)=rbulge
  a(2)=nbulge
  a(3)=fdisk
  a(4)=rdisk
 
;***************************************************************
;restore the save-file containing the profile
; r = radii
; fobs(r) = observed flux
; sigma_f(r) = Gaussian error of flux

  restore,'stati2008_synte.save'
  fobs_com=fobs
  fac=1
  sigma=fac*sigma_f
  
;otetaan synteettiset arvot alkuarvoiksi, hieman virheellisinä
  a=asynte*1.2
  aori=a
  
;***************************************************************
;BULGE+DISK ITERATION
;***************************************************************

 noite=0
;************************************
;no-iteration
;************************************
 
  if(noite eq 1) then begin
     stati2008_bd_model,r,a,f,fb=fb,fd=fd
     goto,endi
     title='noite'
  endif
  
;************************************
;iteration
;************************************

  itmax=50
  tol=1d-4
  noder=1
  w=1.d0/sigma^2
  
  if(check eq 1) then nwin
  if(check eq 1) then print,'   fb      rb      nb       fd      rd      chi2norm'
  
  result=stati2008_curvefit(r,fobs,w,a,sigma_a,chisq=chisq,$
                            function_name='stati2008_bd_model',$
                            iter=iter,noder=noder,$
                            itmax=itmax,tol=tol,/double,alpha=alpha)
  title='#ITER='+string(iter)+'  reduced chi**2 ='+string(chisq)
  
;tarkistus
;stati2008_bd_model,r,a,f,fb=fb,fd=fd
;print,total((f-fobs)^2/sigma^2)/(n_elements(r)-5)

endi:
  nwin
  
  plot,r,fobs,psym=-6,syms=.2,/ylog,xtitle='radius',ytitle='flux',$
       yr=[1d-4,1d4],title=title
  oplot,r,fb+fd,col=5
  oplot,r,fb,col=2
  oplot,r,fd,col=3
  
end
