FUNCTION myfunct, X ,M
 apu=fltarr(4)
 apu(0)=1.0
 apu(1)=sin(2*x)/x
 apu(2)=cos(4*x)^2
 apu(3)=x
 RETURN,apu(0:m-1)
END

;--------------------------------------------------------------
; example of using svdfit
;--------------------------------------------------------------

  program='svdfit_example'
  ps=0.
  psdirect,program,ps

; Provide an array of coefficients and construct the data
  C = [7.77, 8.88, -9.99, 0.]
  X = FINDGEN(100)/15.0 + 0.1
  Y = C[0] + C[1] * SIN(2*X)/X + C[2] * COS(4.*X)^2. + C(3)
  
; Set uncertainties to std=0.8
  seed=10
  y=y+randomn(seed,n_elements(y))*0.8
  measure_errors = y*0.+1
; Provide an initial guess:
   A=[1,1,1,1]
   result_a = SVDFIT(X, Y, A=A, MEASURE_ERRORS=measure_errors, $
                     FUNCTION_NAME='myfunct', SIGMA=SIGMA, YFIT=YFIT, $
                     status=status)
; Plot the results:
  plot,x,y,psym=6,title=program
  oPLOT, X, YFIT
  oplot,x,x*0+result_a(0),col=2
  oplot,x,result_a(1)*sin(2*x)/x,col=3,lines=1
  oplot,x,result_a(2)*cos(4*x)^2,col=4,lines=2
  if(n_elements(a) ge 4) then oplot,x,result_a(3)*x,col=5,lines=3
  
  for I = 0, N_ELEMENTS(A)-1 DO begin
      PRINT, I, result_a[I], SIGMA[I], C[I],$
        FORMAT = $
        '(" result_a ( ",I1," ) = ",F8.4," +- ",F8.4," VS. ",F8.4)'
  endfor
  
  label_data,0.5,0.9,['constant','1/x * sin(2x)','cos(4x)^2','x'],col=[2,3,4,5],lines=[0,1,2,3]
  
  psdirect,program,ps,/stop
END


