;HS 20.11.05
program='runs_test_example'
ps=-2
psdirect,program,ps


!p.multi=[0,1,2]
!p.charsize=1.5
for example=1,2 do begin

;attempt to make a random binary population by-hand:
    if(example eq 1) then begin
        title='NON_RANDOM'
        X=[0,1,1,1,0,1,0,0,1,1,0,0,1,0,1,0,1,0,0,1,1,0,1,0,1,0,0,1,0,1]
    endif
    
;take 30 random numbers r, multiply by 2 and truncate to integer
;so that r<0.5 --> 0 and r>0 -->1
    if(example eq 2) then begin
        title='RANDOM'
        seed=1
        x=long(randomu(seed,30)*2)
    endif
    
    nwin
    plot,x,psym=-4,xtitle='array index',ytitle='array value',$
      yr=[-0.5,1.5],ys=2,title=title
    nx=n_elements(x)
    
    result = R_TEST(X, R = r, N0 = n, N1 = m)
    ntot=n+m
    xyouts,nx/2,1.35,'z='+string(result(0))
    xyouts,nx/2,1.15,'prob(z)'+string(result(1))
    
    print,'-------------------------------------------------------'    
    print,'EXAMPLE= ',example
    PRINT, 'Observed Runs:   ', r
    print, 'Expected Runs:   ',2*n*n/(n+m+1)
    print, 'stdev    Runs:   ',sqrt(2*n*m*(2*n*m-ntot)/ntot^2/(ntot-1))
    print, 'z='+string(result(0))
    print, 'prob(z)'+string(result(1))

; Test the hypothesis that X represents a random sampling against
; the H0 hypothesis that it does not represent a random sampling at
; the 0.05 significance level:

; In example=1  result=[2.00160, 0.0226638]  -->
; The computed probability (0.0226638) is less than the 0.05
; significance level and therefore we reject the H0 hypothesis that X
; represents a random sampling. The results show that there are too
; many runs, indicating a non-random cyclical pattern.

; In example=2 result=[0.100955     0.459793]
; The computed probability (0,459793) exceed the 0.05
; significance level and therefore the H0 remains accepted


endfor

psdirect,program,ps,/stop
!p.charsize=1
end
