;---------------------------------------------------
program='pcomp_trivariate_gaussian'
;---------------------------------------------------

  n=5000l
  m=3
  rho_xy=0.3
  rho_xz=0.7
  rho_yz=0.8

print,'-------------------------------'
print,'trivariate_gaussian_f:'
trivariate_gaussian_f,x,y,z,n,rho_xy,rho_xz,rho_yz,seed=1,plot=[1,1]
array=fltarr(m,n)
array(0,*)=(x-mean(x))/stdev(x)
array(1,*)=(y-mean(y))/stdev(y)
array(2,*)=(z-mean(z))/stdev(z)






result = PCOMP(array, COEFFICIENTS = coefficients, $
               EIGENVALUES=eigenvalues, VARIANCES=variances,/covariance)

print,'---------------------------------------------------------'
print,'Compute principal component variables via PCA (pcomp.pro)
print,'---------------------------------------------------------'
print,'pcomp.pro:'
print,'Coefficients a: '
for i=0,m-1 do begin
    print, i+1, coefficients[*,i], format='("PC",I1,4(F10.4))'
endfor
eigenvectors = coefficients/REBIN(eigenvalues, m, m)
print
print, 'Eigenvectors (unit vectors): '
for i=0,m-1 do begin
    print, i+1, eigenvectors[*,i],format='("PC",I1,4(F10.4))'
endfor

array_reconstruct = result ## eigenvectors
print
print, 'Reconstruction error: ', total((array_reconstruct - array)^2)
print
print, 'Energy conservation: ', total(array^2),total(eigenvalues)*(n-1)
print
print, '    Mode    Eigenvalue    PercentVariance'
for i=0,m-1 do begin
    print, i+1, eigenvalues[i], variances[i]*100
endfor
print,'---------------------------------------------'



ps=0.1
psdirect,program,ps
nwin
!p.multi=[0,1,3]
plot,result(0,*),result(1,*),xtitle='PC1',ytitle='PC2',/iso,psym=3,xr=[-10,10],xs=1,yr=[-3,3],ys=1
plot,result(0,*),result(2,*),xtitle='PC1',ytitle='PC3',/iso,psym=3,xr=[-10,10],xs=1,yr=[-3,3],ys=1
plot,result(1,*),result(2,*),xtitle='PC2',ytitle='PC3',/iso,psym=3,xr=[-10,10],xs=1,yr=[-3,3],ys=1
!p.multi=0
psdirect,program,ps,/stop


END

