program='ladfit_example'
ps=0.1
psdirect,program,ps
  nwin
  !p.multi=[0,2,1]

;---------------------------------------
; Define two n-element vectors of paired data:
  X = [-3.20,  4.49, -1.66,  0.64, -2.43, -0.89, -0.12, 1.41, $
        2.95,  2.18,  3.72,  5.26]
  Y = [-7.14, -1.30, -4.26, -1.90, -6.19, -3.98, -2.87, -1.66, $
       -0.78, -2.61,  0.31,  1.74]

;ordinary least-squares fit
  ab2=LINFIT(X,y)

; minimize abosolute deviation by ladfit.pro
; Sort the X values into ascending order, and sort the Y values to
; match the new order of the elements in X:
  XX = X[SORT(X)]
  YY = Y[SORT(X)]
; Compute the model parameters, A and B:
  ab= LADFIT(XX, YY)

  plot,x,y,psym=4
  xarg=findgen(20)-10
  oplot,xarg,xarg*ab(1)+ab(0),lines=0
  oplot,xarg,xarg*ab2(1)+ab2(0),lines=2
  label_data,0.1,0.9,['minimize D^2','minimize |D|'],lines=[2,0]

;---------------------------------------
;2 plot: add some outliers
  xadd=[-3.,-2.]
  yadd=[-2.,1.]
  x=[x,xadd] &y=[y,yadd]
  plot,x,y,psym=4,title='2 extra points'
  oplot,xadd,yadd,psym=2,syms=2

  ab2=LINFIT(x,y)
  XX = X[SORT(X)] &  YY = Y[SORT(X)] & ab= LADFIT(XX, YY)
  oplot,xarg,xarg*ab(1)+ab(0),lines=0
  oplot,xarg,xarg*ab2(1)+ab2(0),lines=2
  
psdirect,program,ps,/stop
end
