program='kw_example'
ps=.1
psdirect,program,ps


;Test the hypothesis that three sample populations have the same mean
;of distribution against the hypothesis that they differ at the 
;0.05 significance level. 

;Assume we have the following sample populations:
 sp0 = [19.5,18.0, 19.0, 23.0, 24.5, 24.0, 16.7, 22.8, 19.8, 18.9, 17.9]
 sp1 = [20.2,20.3, 22.5, 19.6, 20.3, 23.2, 19.8, 21.1, 17.6, 20.2, 19.8]
 sp2 = [19.0,18.1, 19.3, 19.1, 19.2, 18.2, 19.1, 17.3, 17.3, 19.7, 18.9, 18.8, 19.3]

;Since the sample populations are of unequal lengths, a missing 
;value must be appended to sp0 and sp1. 
;In this example the missing value is -1.0 
;The 3-column, 8-row input array X is defined as:

X = [  [19.5, 20.2, 19.0], $
       [18.0, 20.3, 23.0], $
       [18.2, 22.5, 19.6], $
       [18.1, 19.3, 19.1], $
       [24.0, 23.2, 18.2], $
       [16.7, 19.8, 19.1], $
       [22.8, 21.1, 17.3], $
       [19.8, 17.6, 17.3], $       
       [18.9, 20.2, 19.7], $
       [17.9, 19.8, 18.9], $
       [-1.0, -1.0, 18.8], $
       [-1.0, -1.0, 19.3]]
  PRINT, KW_TEST(X, MISSING = -1)
;  IDL prints:
;  [6.06303    0.0482426]

;  The computed probability (0.048242) is smaller than 
;  the 0.05 significance level and
;  therefore we reject the hypothesis that the 
;  three sample populations sp0, sp1,
;  and sp2 have the same mean of distribution.


nwin
plot,lindgen(2),/nod,xr=[14,25],xs=1,yr=[0,4],ys=1,xtitle='value',title='KW test: probability of H0 is 0.048'
oplot,sp0,sp0*0+3,psym=6,thick=4
oplot,sp1,sp1*0+2,psym=4,thick=4
oplot,sp2,sp2*0+1,psym=2,thick=4

xyouts,14.5,3,'SP0',chars=1.6
xyouts,14.5,2,'SP1',chars=1.6
xyouts,14.5,1,'SP2',chars=1.6





;USE WILCOCON-MANN_WHITNEY U test to look which differ
print,'U-TEST  SP0 and SP1', rs_test(sp0,sp1)
print,'U-TEST  SP1 and SP2', rs_test(sp1,sp2)
print,'U-TEST  SP0 and SP2', rs_test(sp0,sp2)

res01=rs_test(sp0,sp1)
res12=rs_test(sp1,sp2)
res02=rs_test(sp0,sp2)

xyouts,19,0.5,'U-TEST  SP0 and SP1'+string(res01(1))
xyouts,19,0.3,'U-TEST  SP1 and SP2'+string(res12(1))
xyouts,19,0.1,'U-TEST  SP0 and SP2'+string(res02(1))

psdirect,program,ps,/stop
end
