;------------------------------------------
;Model: gaussian with a given sigma
function ks_model,x
   common ks_model_com,sigma
   res=gauss_pdf(x/sigma)
   return,res
end

;------------------------------------------
;main program KS_EXAMPLE_zz
;test the hypothesis that the vwertical profile in 
;a planetary ring simulation follow a Gaussian
;------------------------------------------
   common ks_model_com,sigma

   ps=0.1
   program='ks_example_zz'
   psdirect,program,ps,/color

;---------------------------
;1000 particles
;HOT RING

   restore,'tb_iimodel2_a100tau010.pos'
   data=zz
   sigma=sqrt(mean(data^2))


   !p.multi=[0,2,2]
   nwin
   ff='(f6.4)'

   !x.range=[-20,20]
   !p.title='1000 z values from a HOT simulation'
   histo_f,data,-30,30,1,/plot,/gauss,psym=10
   xyouts,0,0.07,'sigma='+string(sigma,ff)
   !p.title='ACCEPT GAUSSIAN'
   !x.range=[-20,20]*.5
   ksone,data,'ks_model',d,prob,/plot,xtitle='z/radius',ytitle='CFD'
   xyouts,-8,0.8,'D='+string(d,ff)
   xyouts,-8,0.7,'Prob='+string(prob,ff)
   

;---------------------------
;1000 particles
;COLD RING


   restore,'tb_iimodel1_a100tau400.pos'
   data=zz
   sigma=sqrt(mean(data^2))


   !x.range=[-20,20]
   !p.title='1000 z values from a COLD simulation'
   histo_f,data,-30,30,1,/plot,/gauss,psym=10
   xyouts,0,0.07,'sigma='+string(sigma,ff)
   !p.title='REJECT GAUSSIAN'

   !x.range=[-20,20]*.5
   ksone,data,'ks_model',d,prob,/plot,xtitle='z/radius',ytitle='CFD'
   xyouts,-8,0.8,'D='+string(d,ff)
   xyouts,-8,0.7,'Prob='+string(prob,ff)
   
   !p.multi=0
   defplot
   psdirect,program,ps,/stop
   
end


