;use WJ hubble-data
;-------------------------------
program='hubble_example'
ps=.1


;read Hubble(1936) recession velocity vs galaxy distance

d=fltarr(24)
v=fltarr(24)
close,1 & openr,1,'4point1.dat'

for i=0,23 do begin
    readf,1,dd,vv
    d(i)=dd & v(i)=vv
endfor


;------------------------------------------
;bayesian

psdirect,program+'_bayesian',ps
defplot
r=correlate(d,v)
bayesian_rho,r,24,rho,prob_rho,/plot

plot,/noerase,d,v,pos=[0.25,0.35,0.65,0.85],$
  xtitle='distance [MPC]',ytitle='velocity [km/s]',psym=6,syms=.5

psdirect,program+'_bayesian',ps,/stop



;------------------------------------------
;fisher r-test


r=correlate(d,v)
n=24

t=r*sqrt((n-2)/(1.-r^2))




end
