function chisqr_pdf_nocum,x,df
 pdf=2.^(-df/2.)/gamma(df/2.)*x^(df/2.d0-1.)*exp(-x/2.)
 return,pdf
end

;---------------------------------------------------------------
; a1) plot chi-square distribution with different degrees of freedom
;---------------------------------------------------------------
program0='chisqr_illustration'

ps=.1
program=program0+'_a'
psdirect,program,ps,/color
!p.multi=[0,1,2]

  x=findgen(10000)*.01
  y10=chisqr_pdf_nocum(x,10.)
  y20=chisqr_pdf_nocum(x,20.)
  y30=chisqr_pdf_nocum(x,30.)
  y40=chisqr_pdf_nocum(x,40.)
  y50=chisqr_pdf_nocum(x,50.)

  plot,x,y10,xtitle='x',ytitle='Chi_square(x)',yr=[0,.12]
  oplot,x,y20,col=2,lines=2
  oplot,x,y30,col=3
  oplot,x,y40,col=4
  oplot,x,y50,col=5
  
  dy=0.003
  xyouts,ali=.5,10,max(y10)+dy,'v=10'
  xyouts,ali=.5,20,max(y20)+dy,'v=20',col=2
  xyouts,ali=.5,30,max(y30)+dy,'v=30',col=3
  xyouts,ali=.5,40,max(y40)+dy,'v=40',col=4
  xyouts,ali=.5,50,max(y50)+dy,'v=50',col=5
  
  xyouts,60,.10,'mean = v',chars=1.5
  xyouts,60,.09,'variance = 2v',chars=1.5
  

;---------------------------------------------------------------
; a2) cumulative, using IDL function chisqr_pdf
;---------------------------------------------------------------

  x=findgen(10000)*.01
  p10=chisqr_pdf(x,10)          ; probability of chi2 < x
  p20=chisqr_pdf(x,20) 
  p30=chisqr_pdf(x,30) 
  p40=chisqr_pdf(x,40) 
  p50=chisqr_pdf(x,50) 
  p60=chisqr_pdf(x,60) 

  nwin
  plot,x,1.-p10,/ylog,yr=[0.001,1.],xtitle='x',$
    ytitle='Cumulative Chi_square(x)'
  oplot,x,1.-p20,col=2,lines=2
  oplot,x,1.-p30,col=3
  oplot,x,1.-p40,col=4
  oplot,x,1.-p50,col=5
 
  xyouts,ali=.5,19,0.01,'v=10'
  xyouts,ali=.5,33,0.01,'v=20',col=2
  xyouts,ali=.5,46,0.01,'v=30',col=3
  xyouts,ali=.5,59,0.01,'v=40',col=4
  xyouts,ali=.5,71,0.01,'v=50',col=5


psdirect,program,ps,/stop
!p.multi=0


;-------------------------------------------------------
; b) plot p(chi2>x) vs df in contour
;-----------------------------------------------------
program=program0+'_b'
psdirect,program,ps,/color

  nwin
  dftab=2.d0+dindgen(198)
  chi2tab=0.1d0*1.02^dindgen(400)

  ni=n_elements(dftab)
  nj=n_elements(chi2tab)
  pdftab=fltarr(ni,nj)
  
  for i=0,ni-1 do begin
      df=dftab(i)
      pdftab(i,*)=1.d0-chisqr_pdf(chi2tab,df)
  endfor

lev=[0.0001,0.001,0.01,0.1,0.5,0.9,0.99,0.999,.9999]
  contour,pdftab,dftab,chi2tab,lev=lev,$
    /xlog,/ylog,xr=[1,200],yr=[1,200],xs=1,ys=1,c_col=[3,3,3,3,5,2,2,2,2],$
    c_thick=[2,2,2,2,3,1,1,1,1],xticklen=1,yticklen=1,$
    c_lines=[2,2,2,2,0,1,1,1,1],c_anno=string(lev,'(f8.4)'),$
    xtitle='v - degrees of freedom',ytitle='Chi2',$
    title='Prob(Chi2 or larger) if H0 is valid'

oplot,dftab,dftab,lines=3
oplot,dftab,2.*dftab,lines=3


 psdirect,program,ps,/stop
end
