program0='WJ5_1'
ps=0.1

for icase=1,3 do begin

;----------------------------------------
;read WJ data in 5point2.dat
;----------------------------------------
    file='5point2.dat'
    close,1
    openr,1,file
    line=''
    readf,1,line
    readf,1,line
    gal=fltarr(386)
    readf,1,gal
    readf,1,line
    readf,1,line
    readf,1,line
    sky=fltarr(290)
    readf,1,sky
    close,1
;----------------------------------------
;make an artificial offset to galaxy-data?
    if(icase eq 1) then begin
        program=program0+'_a'
        title='WJ EXERCISE 5.1/5.2'
    endif
    if(icase eq 2) then begin
        program=program0+'_b'
        title='WJ EXERCISE 5.1/5.2 + artificially added 0.5 to galaxy data'
        gal=gal+0.5
    endif  
    if(icase eq 3) then begin
        program=program0+'_c'
        title='WJ EXERCISE 5.1/5.2 + artificially spread galaxy data by 1.25'
        gal=gal*1.25
    endif  
    psdirect,program,ps
;----------------------------------------
;plot histograms
;histo_f,x,x1,x2,dx,xx,yy,gg
    histo_f,gal,-20,20,1,xt,yt_gal,/nos
    histo_f,sky,-20,20,1,xt,yt_sky,/nos    
    nwin
    plot,xt,yt_gal,xtitle='flux density mJy',ytitle='Number',psym=10,$
      title=title,yr=[0,50],ys=1,thick=2
    oplot,xt+.02,yt_sky+.2,psym=10,lines=2,col=2,thick=3  
    label_data,0.55,0.95,['GALAXY','SKY'],lines=[0,2]
    
;KSTWO
; Return the Kolmogorov-Smirnov statistic and associated 2-tailed probability 
; that two arrays of data values are drawn from the same distribution
    kstwo,gal,sky,d,prob
    print,'-------------------------------------'
    print,'kstwo:'
    print,'Maximum D',d
    print,'Probability in two tailed test',prob    
;One-tailed test-statistic
    m=n_elements(gal)
    n=n_elements(sky)
    chi2=4*d^2*m*n/(m+n)
    print,'chi2-statistic', chi2
    print,'probability in one-tailed test:', 1-chisqr_pdf(chi2,2)
    
    xyouts,-18,38,'KS-test: (kstwo.pro)'
    xyouts,-18,36,'max D'+string(d,'(f6.3)')
    xyouts,-18,34,'1-tailed significance: (gal>sky)'
    xyouts,-16,32,string(1-chisqr_pdf(chi2,2),'(f6.3)')

    if(icase eq 3) then begin
        xyouts,-18,28,'2-tailed significance: (gal ne sky)'
        xyouts,-16,26,string(prob,'(f6.3)')
    endif
;----------------------------------------------------------------------------
;Apply Wilcoxon-Mann-Whitney test
;       RS_TEST(X,Y) tests the hypothesis that two sample populations,
;       {X[i], Y[i]}, have the same mean of distribution against the
;       hypothesis that they differ. The result is a two-element vector
;       containing the nearly-normal test statistic Z and the one-tailed
;       probability of obtaining a value of Z or greater. This type of 
;       test is often refered to as the Wilcoxon Rank-Sum Test or Mann-
;       Whitney U-Test.
    
    res=rs_test(sky,gal)
    Z=res(0)
    prob=res(1)
    print,'-------------------------------------'
    print,'rs_test:'
    print,'Z',Z
    print,'Probability in one-tailed test',prob

    xyouts, 8,38,'U-test: (rs_test.pro)'
    xyouts, 8,36,'Z'+string(Z,'(f6.3)')
    xyouts, 8,34,'1-tailed significance: (gal>sky)'
    xyouts, 10,32,string(prob,'(f6.3)')

    psdirect,program,ps,/stop
endfor
end

