;-------------------------------------------------------------------------
;idlharj2_boxmuller
;-------------------------------------------------------------------------
;Gaussisesti jakautuneiden satunnaislukujen luonti Box-Muller menetelmalla
;-------------------------------------------------------------------------
   program='idlharj2_boxmuller'
   ps=0
   psdirect,program,ps,/color
;tasaisesti jakaantuneet
   n=10000
   x1=randomu(seed,n)
   x2=randomu(seed,n)

;nama ovat normaalijakauman (mu=0, sigma=1)
;mukaisesti jakaantuneet
   y1=sqrt(-2*alog(x1))*cos(2*!pi*x2)
   y2=sqrt(-2*alog(x1))*sin(2*!pi*x2)

;y1 histogrammi valilla -5*sigma -> 5*sigma
;y2 vastaava (tarkista!)
  histo_f,y2,-5.,5.,.05,xx,yy
  nwin
  plot,xx,yy,psym=10,xtitle='x',ytitle='pdf',xs=1,$
       title='Box-Muller menetelmällä luotuja satunnaislukuja'

;teoreeettinen tiheysjakauma
  xteo=-5.+10*findgen(1001)/1000.
  yteo=1./sqrt(2.*!pi)*exp(-0.5*xteo^2)
  oplot,xteo,yteo,lines=0,col=2,thick=3
    
  psdirect,program,ps,/stop
end
 
