

 pro tvplot2, a, ASPECT = aspect,$
     log=log,levels0=levels0,smooth0=smooth0,title0=title0,$
     nonew=nonew,noerase0=noerase0,noaxis=noaxis,xx0=xx0,yy0=yy0,$
              xtitle0=xtitle0,ytitle0=ytitle0,collev=collev


;+
; NAME:
;	tvplot2
;
; PURPOSE:
;	Overlay an image and a contour plot.
;
; CATEGORY:
;	General graphics.
;
; CALLING SEQUENCE:
;	tvplot2, A
;
; INPUTS:
;	A:	The two-dimensional array to display.
;
; KEYWORD PARAMETERS:

;	ASPECT:	Set this keyword to retain the image's aspect ratio.
;		Square pixels are assumed.  
;
;       LOG:    LOG PLOT of IMAGE>log(0)<log(1)
; OUTPUTS:
;	No explicit outputs.
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	The currently selected display is affected.
;
; RESTRICTIONS:
;	None.
;
; PROCEDURE:
;	If the device has scalable pixels, then the image is written over
;	the plot window.
;
; MODIFICATION HISTORY:
;	DMS, May, 1988.
;-


if(n_params() le 0) then begin

    
 print,'tvplot2, a, ASPECT = aspect,log=log,levels0=levels0,smooth0=smooth0,title0=title0, $'
 print,' nonew=nonew,noerase0=noerase0,noaxis=noaxis,xx0=xx0,yy0=yy0,$ '
 print,'             xtitle0=xtitle0,ytitle0=ytitle0,collev=collev'

print,'plot image a'
print,'/aspect -> retain correct aspect ratio'
print,'title,xtitle,ytitle  -> title and labels'
print,'xx=xxvalues = x-axis values= table of size nx (def=findgen(nx) where nx = image x-size)'
print,'yy=yyvalues = y-axis values= table of size ny (def=findgen(ny) where ny = image y-size)'
print,'example: image=512*512    pix-size=pix, center xc,yc    xx=(findgen(512)-xc)*pix'
print,'noaxis =1  ei xy  2-ei y 3-ei x akselia' 
print,'levels=levels  overplot contour levels'
print,'collev  = colors of levels'
    return
endif


on_error,2                      ;Return to caller if an error occurs
sz = size(a)			;Size of image
if sz[0] lt 2 then message, 'Parameter not 2D'

if(not keyword_set(nonew)) then nwin_hs
title=''
if(keyword_set(title0)) then title=title0

adens=a
if(keyword_set(log)) then adens=alog(a>log(0)<log(1))

noerase=0
if(keyword_set(noerase0)) then noerase=1
;print,'noerase=',noerase

;set window used by contour
contour,[[0,0],[1,1]],/nodata, xstyle=4, ystyle = 4,noerase=noerase

px = !x.window * !d.x_vsize	;Get size of window in device units
py = !y.window * !d.y_vsize

swx = px[1]-px[0]		;Size in x in device units
swy = py[1]-py[0]		;Size in Y

six = float(sz[1])		;Image sizes
siy = float(sz[2])

aspi = six / siy		;Image aspect ratio
aspw = swx / swy		;Window aspect ratio
f = aspi / aspw			;Ratio of aspect ratios


;*************************************************************
;OUTPUT IMAGE
;*************************************************************

;retain image aspect ratio by adjusting the window size?

if(keyword_set(aspect)) then begin  
    if(f le 1.0) then swx = swx * f
    if(f ge 1.0) then swy = swy / f
endif		

;************************
;Scalable pixels?  PS
;scale image to plot-window
;************************

   if(!d.flags and 1) ne 0 then begin	
       tvscl,adens,px[0],py[0],xsize = swx, ysize = swy, /device 
   endif

;************************
;Not scalable pixels?  X
;scale image to plot-window by resampling the image
;************************

   if(!d.flags and 1) eq 0 then begin

;use cubic interpolation
       interp=2 & cubic=-.5
       tv,poly_2d(bytscl(adens),[[0,0],[six/swx,0]], [[0,siy/swy],[0,0]],$
                  interp,swx,swy,cubic=cubic),px[0],py[0]
   endif			

;*************************************************************
;overlay image-contours
;*************************************************************

xx=lindgen(six)
yy=lindgen(siy)

if(keyword_set(xx0)) then xx=xx0
if(keyword_set(yy0)) then yy=yy0




if(keyword_set(levels0)) then levels=levels0
;goto, eit
levels=0.1*min(a)


   mx = !d.n_colors-1		;Brightest color
   colors = [mx,mx,mx,0,0,0]	;color vectors

   aa=a
   if(keyword_set(smooth0)) then begin
       aa=smooth(a,smooth0)
       aa(0:smooth0,*)=-10*max(levels)
       aa(*,0:smooth0)=-10*max(levels)
       nx=n_elements(aa(*,0))
       ny=n_elements(aa(0,*))
       aa(nx-smooth0:*,*)=-10*max(levels)
       aa(*,ny-smooth0:*)=-10*max(levels)

endif



;   colors=levels*0.
   if(keyword_set(collev)) then colors=collev


   xst=1
   yst=1
   if(keyword_set(noaxis)) then begin
       if(noaxis eq 1) then begin
           xst=15
           yst=15
       endif
       if(noaxis eq 2) then begin
           xst=15
       endif
       if(noaxis eq 3) then begin
           yst=15
       endif
   endif

   xtitle=''
   ytitle=''
   if(keyword_set(xtitle0)) then xtitle=xtitle0
   if(keyword_set(ytitle0)) then ytitle=ytitle0

;POISTETAAN VALKOINEN HAAMUKE
   IF(NOT KEYWORD_SET(LEVELS0)) THEN    min_val=max(aa)

   contour,aa,/noerase,xs=xst,ys=yst,c_color= colors,levels=levels,$
	   pos = [px[0],py[0], px[0]+swx,py[0]+swy],/dev,xx,yy,$
     xtitle=xtitle,ytitle=ytitle,title=title,min_val=min_val

;endif

eit:

;*************************************************************


return
end















