;----------------------------------------
pro pipeline_2to3_interface_f,datalist_ide
;----------------------------------------
;subroutine version of pipeline_2to3_interface.pro


;Two-fold purpose:
;1) make  datalist- file for eventual creation of galfit input parameter files
;2) make a driver procedure for making the sigma images 
;   = 'make_sigma_image_driver.pro'
;      this need to be run separately!


;read from pipeline2.datalist0 -> pipeline2.datalist
;replace weight images with the calculated sigma-images
;replace image and mask to new files with NaN's removed 
;set exptime=1


infile='s4g_pipeline2.datalist0'
outfile='s4g_pipeline2.datalist'
driverfile='make_sigma_image_driver.pro'

infile=datalist_ide+'.datalist0'
outfile=datalist_ide+'.datalist'
driverfile=datalist_ide+'_make_sigma_driver.pro'


close,1
openr,1,infile

close,2
openw,2,outfile,wid=120

close,3
openw,3,driverfile,wid=120

line=''
readf,1,line    ;version line
printf,2,line 

;comment lines
readf,1,line & printf,2,line 
readf,1,line & printf,2,line 
readf,1,line & printf,2,line 
readf,1,line & printf,2,line 
readf,1,line & printf,2,line 

while not eof(1) do begin
   
   readf,1,line
   start=strmid(line,0,1)
   
   if(strmid(line,0,1) ne '#') then begin ;not a comment
   print,line
   res=strsplit(line,/extr)
   ide=res(0)
   data_fits=res(1)
   xc=float(res(2))-1.
   yc=float(res(3))-1.
   pas=res(4)
   incs=res(5)
   mask_fits=res(6)
   weight_fits=res(7)
   psf=res(8)


;make_sigma_image.pro:
; nonan indicates than NaNs have been removed from the image
; and marked in the new mask image
; also set EXPTIME keyword to unity

   mask_new=remove_tag(mask_fits)+'_nonan.fits'
   image_new=remove_tag(data_fits)+'_nonan.fits'
   sigma_fits=remove_tag(data_fits)+'_sigma.fits'

   make_sigma_image,$
      data_fits, mask_fits, weight_fits, sigma_fits, $
      fudge=2, mask=mask_new, image=image_new ;check=[xc,yc,10.]


   sep='    '
   printf,2,ide+sep+image_new+string(xc+1)+string(yc+1)+sep+pas+sep+incs+sep+$
          mask_new+sep+sigma_fits+sep+psf

   cmd="make_sigma_image,'"+data_fits+"','"+mask_fits+"','"+weight_fits+"','"+sigma_fits+$
       "',check=["+string(xc)+","+string(yc)+",10],fudge=2"
   printf,3,cmd

endif
skip:
endwhile

close,1
close,2
printf,3,'end'
close,3




print,'------------------------------------------------------------------------'
print,'CONVERTED ',infile,' --> ',outfile
print,'(contains the names of  SIGMA fits-files)'
print,''
print,'REMEMBER TO CREATE THE SIGMA FITS_FILES!'
print,'.run ',driverfile
end
