;------------------------------------------------------------
pro outgal_to_ingal,infile,ide1,ide2
;------------------------------------------------------------
if(n_params() le 1) then begin
   print,'--------------------------------------------------------------'
   print,'outgal_to_ingal,outgal,ide1,ide2'
   print,'--------------------------------------------------------------'
   print,'Copy old outgal (or ingal) to a new ingal,' 
   print,'            replacing ide1 with ide2 in both'
   print,'            the name and content of the new ingal'
   print,'Also opens the new outgal-file in emacs'
   print,'--------------------------------------------------------------'
   print,'example: '
   print,"outgal_to_ingal,'NGC1097_36_bd.ingal','_bd','_bdtest'"
   print,'--------------------------------------------------------------'
   print,'HS 110810'
   return
endif
;------------------------------------


;copy old outgal to a new ingal file

  outfile=infile
  str_replace,outfile,ide1,ide2,max=1
;just in case an ingal-file is modified
  str_replace,outfile,'outgal','ingal',max=1
  job_edit2,infile,outfile,ide1=ide1,ide2=ide2,'asd','asd',/silent

;open emacs

  cmd='emacs '+outfile+' &'
  spawn, cmd
end
