pro galfit_run_new,ide,ps=ps,sample0=sample0,new=new,$
                   silent0=silent0,pa=pa,xr0=xr0,show=show

  if(n_params() le 0) then begin
     print,'================================================'
     print," galfit_run_new,IDE"
     print,'   1) make GALFIT iterations  or'
     print,'   2) display previously made iterations'
     print," Display IDE.ingal, iterate, display IDE.outgal"
     print,'================================================'
     print,' Keywords:'
     print,'  /new --> Remove old outgal and subcomps' 
     print,'           and  make new iteration'
     print,'           Default: display the previously made' 
     print,'           galfit iteration if this exists'
     print,'  sample =sampling factor of plots (def=2)'
     print,'  pa -> phi of major axis plots (def: disk PA)'
     print,'  /silent'
     print,'  xr=[xrmin,xrmax]'
     print,'  ps=-2 --> store results to ps and png-files'
     print,' /show -> show also major/minor axis plots'
     print,'================================================'
     print,'EXAMPLE:'
     print,"  galfit_run,'ngc1097_example'"
     print,'================================================'
     print,'heikki.salo@oulu.fi  070110/290710'
     print,'================================================'
     return
  endif

!except=0
  infile=ide+'.ingal'
  outfile=ide+'.outgal'

  close,22
  openr,22,infile,error=stat
  if(stat ne 0) then begin
     print,infile,' does not exist -> return'
     return
  endif

;less output?
  silent=0
  if(keyword_set(silent0)) then silent=silent0

;use less points in plots?
  sample=2.
  if(keyword_set(sample0)) then sample=sample0

;perform new galfit iteration?
  if(keyword_set(new)) then begin
     cmd='rm '+outfile+'*'
     spawn,cmd
     cmd='rm '+infile+'_subcomps.save'
     spawn,cmd
  endif

;modify default range?
  xr=0
  if(keyword_set(xr0)) then xr=xr0



;================================================================
;make 2*2 plot displaying
;ingal:   linear and logarithmic xscale
;outgal:  linear and logarithmic xscale

  if(keyword_set(ps)) then psdirect,ide+'_in_out',ps,/color


  !p.multi=[0,2,2]

;display ingal

  galfit_display_new,infile,/restore,prof=-1,sample=sample,$
                     xlog=1,silent=silent,xr=xr
  galfit_display_new,infile,/restore,prof=-1,xlog=0,sample=sample,$
                     silent=silent,xr=xr


;make galfit iteration
;ok=-1  -> iteration has failed -> exit from the procedure

  galfit_iterate,infile,outfile,ok=ok

;iteration fails?
  if(ok eq -1) then begin


;added 090810 HS:
;indicate that iteration has failed
cmd='cp '+infile+' '+outfile+'_failed'
spawn,cmd

     xyouts,0.5,0.2,/normal,ali=0.5,size=3,'ITERATION FAILED'
     if(keyword_set(ps)) then psdirect,ide+'_in_out',ps,/color,/stop
     !p.multi=0
     goto,endi
  endif


;display outgal

  galfit_display_new,outfile,/restore,prof=-1,/store,xlog=1,$
                     sample=sample,silent=silent,xr=xr
  galfit_display_new,outfile,/restore,prof=-1,xlog=0,$
                     sample=sample,silent=silent,xr=xr

  if(keyword_set(ps)) then psdirect,ide+'_in_out',ps,/color,/stop

  !p.multi=0



;================================================================
;major/minor
  if(keyword_set(show) or keyword_set(ps)) then begin
     if(keyword_set(ps)) then psdirect,ide+'_majorminor',ps,/col
     galfit_display_new,outfile,/restore,major=999,silent=silent
     if(keyword_set(ps)) then psdirect,ide+'_majorminor',ps,/stop
  endif


;================================================================
;major axis components
  pa_use=999
  if(keyword_set(pa)) then pa_use=pa
  
  if(keyword_set(show) or keyword_set(ps)) then begin
  if(keyword_set(ps)) then psdirect,ide+'_pa',ps,/col
  galfit_display_new,outfile,/restore,silent=silent,pa=pa_use
  if(keyword_set(ps)) then psdirect,ide+'_pa',ps,/stop
endif

;================================================================
;profile=-2 plot

  if(keyword_set(ps)) then psdirect,ide+'_profile',ps,/col
  galfit_display_new,outfile,/restore,silent=silent,prof=-2
  if(keyword_set(ps)) then psdirect,ide+'_profile',ps,/col,/stop

  if(keyword_set(ps)) then psdirect,ide+'_logprofile',ps,/col
  galfit_display_new,outfile,/restore,silent=silent,prof=-2,/xlog
  if(keyword_set(ps)) then psdirect,ide+'_logprofile',ps,/col,/stop


;================================================================
;residuals

  if(keyword_set(ps)) then psdirect,ide+'_model',ps
  galfit_display_new,outfile,/restore,/residual,silent=silent
  if(keyword_set(ps)) then psdirect,ide+'_model',ps,/stop

  galfit_print,outfile


endi:

  
end
