pro galfit_print,infile0,profile=profile,residual=residual,stop=stop,$
                 flux=flux,xr0=xr0,yr0=yr0,structure0=structure0,$
                 restore=restore,storefits=storefits,xlog0=xlog0,sample0=sample0,$
                 pa0=pa0,majorminor=majorminor,silent=silent,arcsec=arcsec,run=run,cut=cut,$
                 title0=title0,ps=ps,addps=addps
  
  if(n_params() le 0) then begin
     print,'============================================================================'
     print,' galfit_print,INFILE'
     return
  endif


info=0
;----------------------------------------------------
;check that INFILE exist 
  
  close,22
  openr,22,infile0,err=stat
  if(stat ne 0) then begin
     print,infile0,' does not exist -> exit galfit_print'
     return
  endif

;--------------------------------------------------------
;check that INFILE is not an empty output, 
;produced by a crashed galfit iteration

  line=''
  readf,22,line
  if(strpos(line,'crashed') ne -1) then begin
     print,infile0,' is empty(galfit crashed) -> exit galfit_print'
     return
  endif
  close,22


;------------------------------------------------------------
; 1) read the INFILE file
;------------------------------------------------------------
; this can be ngcXXXX.ingal or outgal
; IF it contains added STRUCTURE keywords
; --> this information is displayed in the plot 
;     otherwise, comp=1, comp=2 etc are used
;------------------------------------------------------------

  input_file=infile0
  ide=infile0
  close,1
  openr,1,input_file
  line=''

;the following data will be read from infile

  data_image='unknown'
  out_image='unknown' 
  sigma_image='none'
  psf_image='none'
  mask_image='none'
  xc=-1.
  yc=-1.
  pix=0.75
  zeropoint=20.472-5*alog10(pix)
  string_comps=' '
  pix=1.
  
  mui_pos=-1                     
  mui_disk_pa=-1
  pa_disk=-90

  while not eof(1) do begin
     readf,1,line

;searching STRUCTURE lines = optional comment lines in ingal-file
;identifying the structure component

     if(strpos(line,'STRUCTURE') ne -1 and strpos(line,'STRUCTURE') le 5) $
     then begin
        apu=str_sep(line,' ') & apu=apu(where(apu ne ''))
        string_comps=[string_comps,apu(2)]
                                ; print,line
     endif


;searching standard galfit input lines
     if(strpos(line,'#') ne 0) then begin ;unless a comment file

        if(strpos(line,'A)') ne -1 and strpos(line,'A)') le 2)then begin
           apu=str_sep(line,' ') & apu=apu(where(apu ne ''))
           data_image=apu(1)
        endif
        if(strpos(line,'B)') ne -1) then begin
           apu=str_sep(line,' ') & apu=apu(where(apu ne ''))
           out_image=apu(1)
        endif
        if(strpos(line,'C)') ne -1) then begin
           apu=str_sep(line,' ') & apu=apu(where(apu ne ''))
           sigma_image=apu(1)
        endif
        if(strpos(line,'D)') ne -1) then begin
           apu=str_sep(line,' ') & apu=apu(where(apu ne ''))
           psf_image=apu(1)
        endif
        if(strpos(line,'F)') ne -1) then begin
           apu=str_sep(line,' ') & apu=apu(where(apu ne ''))
           mask_image=apu(1)
        endif
        if(strpos(line,'H)') ne -1) then begin
           apu=str_sep(line,' ') & apu=apu(where(apu ne ''))
           xmin=float(apu(1))
           xmax=float(apu(2))
           ymin=float(apu(3))
           ymax=float(apu(4))
           region_line=line
        endif
        if(strpos(line,'J)') ne -1) then begin
           apu=str_sep(line,' ') & apu=apu(where(apu ne ''))
           zeropoint=float(apu(1))
        endif
        if(strpos(line,'K)') ne -1) then begin
           apu=str_sep(line,' ') & apu=apu(where(apu ne ''))
           pix=float(apu(1))
        endif
        
;searching center position of the FIRST component,
;used in all profile plots

        npos=strpos(line,'1)')
        npos2=strpos(line,'osition')
        if(mui_pos eq -1 and npos ne -1 and npos le 2 and npos2 ne -1) then begin
           apu=str_sep(line,' ') & apu=apu(where(apu ne ''))
           xc=float(apu(1))
           yc=float(apu(2))
           mui_pos=1
        endif

;searching disk_pa: first 'Position angle' line after 'expdisk'

        if(mui_disk_pa eq 1) then begin
           npos3=strpos(line,'osition angle')
           if(npos3 ne -1) then begin
              apu=str_sep(line,' ') & apu=apu(where(apu ne ''))
              pa_disk=float(apu(1))
              mui_disk_pa=2
           endif
        endif


;     print,line
;     print,mui_disk_pa
;     print,pa_disk
;     vast=''
;     read,vast


        if(mui_disk_pa eq -1) then begin
           if((strpos(line,'expdisk') ne -1 or strpos(line,'egdedisk') ne -1) $
              and strpos(line,'sersic') eq -1) then mui_disk_pa=1
        endif

     endif                      ; not a comment

  endwhile
  close,1


;default xrange
  xr_min=1
  xr_max=max([xc-xmin,yc-ymin,xmax-xc,ymax-yc])*1.4
  xr=[xr_min,xr_max]
  
;use pixels or arcsec?
  pix_use=1.
  xunit='[pix]'

  print,'----------------------------------------'
  print,'GALFIT-file = ',input_file
  print,'----------------------------------------'
  print,'data_image  = ',data_image
  print,'out_image   = ',out_image
  print,'sigma_image = ',sigma_image
  print,'psf_image   = ',psf_image
  print,'mask_image  = ',mask_image
  print,'XC,YC:',xc,yc
  print,'REGION',long(xmin),long(xmax),long(ymin),long(ymax),f='(A6,4x,2i5,3x,2i5)'
  print,'----------------------------------------'

;  print,'ZP:',zeropoint
;  print,'pix:',pix
;  print,'PA_DISK:', pa_disk

  
;-------------------------------------------------------------
; 2) Making subcomps.fits file
;-------------------------------------------------------------

;--------------------------------------------------
; Need the subcomponent fits-file ?
; if either /profile, /residual, /pa /major is set

need_subcomp=1
file=ide+'_subcomps.save'
close,22 & openr,22,file,err=stat
if(stat eq 0) then begin
   if(info ge 1) then  print,'restoring SUBCOMPS'
   restore,file
   need_subcomp=0
endif



;--------------------------------------------------
; Call galfit -o3 to make the subcomponent fits-file

  if(need_subcomp eq 1) then begin
     if(info ge 1) then print,'CREATE SUBCOMPS'

;subcomponents to "subcomps.fits"

     cmd='galfit -o3 '+input_file
     spawn,cmd,res     
     fits_info,'subcomps.fits',/sil,n_ext=n_ext
     
;galfit stores masked obs image

     obs=readfits('subcomps.fits',ext=1,header,/sil)
     nx=sxpar(header,'naxis1')  
     ny=sxpar(header,'naxis2')
     
     ncomps=n_ext-1
     comps=fltarr(nx,ny,ncomps)
     frac_comps=fltarr(ncomps)
     
     if(n_elements(string_comps) lt ncomps) then begin
        string_comps=replicate(' ',ncomps)
        for i=0,ncomps-1 do begin
           string_comps(i)='Comp '+string(i+1,'(i1)')
        endfor
     endif
     
;read the components

     model=obs*0.
     for i=0,ncomps-1 do begin
        comps(*,*,i)=readfits('subcomps.fits',ext=i+2,header,/sil)
        model=model+comps(*,*,i)
        frac_comps(i)=total(comps(*,*,i))
     endfor
     frac_comps=frac_comps/total(model)    
     for i=0,ncomps-1 do begin
        print,string_comps(i),' = ',frac_comps(i)
     endfor   
     
     subcomp_header=header
     
;image section

     fitsect=sxpar(header,'fitsect')
     apu=strsplit(fitsect,'[:,]',/ext)
     x1=apu(0)
     x2=apu(1)
     y1=apu(2)
     y2=apu(3)
     
;read original unmasked obs-image    

     obs=readfits(data_image,/sil)
     obs=obs(x1-1:x2-1,y1-1:y2-1)
     

;masked image

     obs_mask=obs
     if(mask_image ne 'none' ) then begin
        mask=readfits(mask_image,/sil)
        mask=mask(x1-1:x2-1,y1-1:y2-1)
        ind=where(mask ne 0,count)
        if(count ge 1) then obs_mask(ind)=0
     endif


;create array of sky distances
     
     xc_idl=xc-x1
     yc_idl=yc-y1
     dist_circle,rad,[nx,ny],xc_idl,yc_idl
     
     if(keyword_set(stop)) then stop
     
     save,file=ide+'_subcomps.save',$
          model,obs,comps,rad,ncomps,string_comps,frac_comps,zeropoint,$
          x1,x2,y1,y2,xc,yc,nx,ny,$
          data_image,out_image,sigma_image,psf_image,mask_image,xc_idl,yc_idl,$
          subcomp_header,obs_mask

;save to INFILE_subcomps.fits?

     if(keyword_set(storefits)) then begin
        cmd=' cp -rp subcomps.fits '+ide+'_subcomps.fits'
        spawn,cmd
     endif
     
  endif                         ; need_subcomp eq 1
;-------------------------------------------------------------------

 
  for i=0,n_elements(FRAC_COMPS)-1 do begin
     print,string_comps(i),'=',frac_comps(i),format='(a-10,1a,4x,f6.4)'
 endfor
print,' '
;
     mui=0
     okmui=0
     nlines=n_elements(subcomp_header)
     for i=17,nlines-1 do begin
        line=Subcomp_HEADER(i)
        line=strjoin(strsplit(line,"'",/ext))
;        print,line
        if(strpos(line,'CHISQ') ne -1) then mui=1
        if(strpos(line,'Degrees of') ne -1) then mui=1
        
        ok=1
        if(strpos(line,'_XC') ne -1) then ok=0
        if(strpos(line,'_YC') ne -1) then ok=0
        
        if(strpos(line,'COMMENT') ne -1) then line='-------------------------'
        posi=strpos(line,'/')
        if(n_elements(posi) ne 0) then begin
           if(n_elements(posi) eq 1) then begin
              line=strmid(line,0,posi-1)
           endif
           if(n_elements(posi) eq 2) then begin
              line=strmid(line,0,posi(1)-1)
              endif
        endif
        
        step=1.
        if(strtrim(line,2) eq '') then step=.5
        
        if(mui eq 0 and ok eq 1) then print,line

  endfor






     res=obs-model
     obs_mask=obs
     res_mask=res

     npix=n_elements(res)

     if(mask_image ne 'none' ) then begin
        mask=readfits(mask_image,/sil)
        mask=mask(x1-1:x2-1,y1-1:y2-1)
        ind=where(mask ne 0,count)
        npix=npix-count
        if(count ge 1) then obs_mask(ind)=0
        res_mask=res
        if(count ge 1) then res_mask(ind)=0
     endif

     sigma=readfits(sigma_image,/sil)
     sigma=sigma(x1-1:x2-1,y1-1:y2-1)
     
     chi2_title=total(res_mask^2/sigma^2)/npix
     print,'Chi2/nu=', chi2_title
     

end
