;---------------------------------------------------------
pro datalist0_to_datalist,datalist_ide,s4g_dir0=s4g_dir0
;  pro pipeline_2to3_interface_f_new,datalist_ide,s4g_dir0=s4g_dir0
;---------------------------------------------------------
;subroutine version of pipeline_2to3_interface.pro

    if(n_params() le 0) then begin
       print,'--------------------------------------------------------'
       print,'datalist0_to_datalist,ide'
       print,'--------------------------------------------------------'
       print,'PIPELINE3: second procedure to call'
       print,'writes ide.datalist0 -> ide.datalist'
       print,'makes the needed sigma, nonan-image, and new-mask'
       print,' '
       print,' ide.datalist:'
       print,' #-marks comment lines - do not include these'
       print,' ##-skip the rest'
       print,'--------------------------------------------------------'
       print,' heikki.salo@oulu.fi 10.12.2009'
       print,'--------------------------------------------------------'
       print,' New keyword 250510 HS:'
       print,'  s4g_dir=s4g_directory  '
       print,'  old def ~/S4G/PRODUCTS/ARCHIVAL/GALIDE/P1'
       print,'  to use current directory, use'      
       print,"  datalist0_to_datalist,ide,s4g='./'"
       print,'--------------------------------------------------------'
       print,' Modified 090610 HS:'
       print,'  datalist contains now sky_subtract values (version=2),'
       print,'  which are subtracted from nonan-images'
       print,'  Note: if datalist0 does not contain sky_subtract (version=1)'
       print,'  this is set to zero in datalist'
       print,'--------------------------------------------------------'
       return
    endif
    
;Two-fold purpose:
;1) make datalist-file for the creation of galfit input parameter files
;   and make the needed sigma-, nonan- images

;2) write a separate driver-procedure for making the sigma images 
;   = 'make_sigma_image_driver.pro'
;      this can be run separately to get visual check of sigma-images
    
;read from pipeline2.datalist0 -> pipeline2.datalist
;replace weight images with the calculated sigma-images
;replace image and mask to new files with NaN's removed 
;set exptime=1
;remove sky-value (090610)


    S4G_DIR='~/S4G/PRODUCTS/ARCHIVAL/'

    infile=datalist_ide+'.datalist0'
    outfile=datalist_ide+'.datalist'
    driverfile=datalist_ide+'_make_sigma_driver.pro'
    


    close,1
    openr,1,infile
    
    close,2
    openw,2,outfile,wid=120
    
    close,3
    openw,3,driverfile,wid=120
    
    line=''
    readf,1,line                ;version line
    print,'datalist0:  ',line

    version=0
    if(line eq 'version=1') then version=1
    if(line eq 'version=2') then version=2

    line='version=2'
    print,'datalist:   ',line
    printf,2,line

    printf,2,'# ============================================================'
    printf,2,'# Interface between P1/P2 and P4'
    printf,2,'# datalist-file made from infile= '+infile
    printf,2,'# '+mywhoami()+'@'+hostname(),'    ',!stime
    printf,2,'# ============================================================'
    printf,2,'# IDE  image  XC(iraf)  YC(iraf)  PA  ELLIP  A26p5  AMULT SKY '+$
           '    mask  sigma    psf' 
    printf,2,'#'
 
;comment lines
    while not eof(1) do begin
       
       readf,1,line
       start=strmid(line,0,1)
       if(strmid(line,0,2) eq '##') then goto,endi
       if(line ne '' and strmid(line,0,1) ne '#') then begin ;not a comment
          
          print,line
          res=strsplit(line,/extr)

;original version december 2009 (for IAC P3 workshop)
          if(version eq 0) then begin
             ide=res(0)
             data_fits=res(1)
             xc=float(res(2))-1. ;iraf --> idl
             yc=float(res(3))-1. ;iraf --> idl
             pas=res(4)
             incs=res(5)
             amas=res(6)
             amultis='1.3'
             skys='0.'
             dskys='0.'
             mask_fits=res(7)
             weight_fits=res(8)
             psf=res(9)
          endif          

; modified version, GALFIDL_RELEASE_110110
          if(version eq 1) then begin
             ide=res(0)
             data_fits=res(1)
             xc=float(res(2))-1. ;iraf --> idl
             yc=float(res(3))-1. ;iraf --> idl
             pas=res(4)
             incs=res(5)
             amas=res(6)
             amultis=res(7)
             skys='0.'
             dskys='0.'
             mask_fits=res(8)
             weight_fits=res(9)
             psf=res(10)
          endif          


; modified version, GALFIDL_RELEASE_100610
; subtract_sky

          if(version eq 2) then begin
             ide=res(0)
             data_fits=res(1)
             xc=float(res(2))-1. ;iraf --> idl
             yc=float(res(3))-1. ;iraf --> idl
             pas=res(4)
             incs=res(5)
             amas=res(6)
             amultis=res(7)
             skys=res(8)
             dskys=res(9)
             mask_fits=res(10)
             weight_fits=res(11)
             psf=res(12)
          endif          


;build directory path to original data
          sep=strpos(ide,'_')
          idegal=strmid(ide,0,sep)
          datadir=S4G_DIR+idegal+'P1/'
          if(keyword_set(s4g_dir0)) then datadir=s4g_dir0
             
;make_sigma_image.pro:
; nonan indicates than NaNs have been removed from the image
; and marked in the new mask image
; also set EXPTIME keyword to unity
; and subtract skys
          
          mask_new=remove_tag(mask_fits)+'_nonan.fits'
          image_new=remove_tag(data_fits)+'_nonan.fits'
          sigma_fits=remove_tag(data_fits)+'_sigma.fits'
          
;make them
          
          make_sigma_image_new,$
             data_fits, mask_fits, weight_fits, sigma_fits, $
             fudge=2, mask=mask_new, image=image_new,datadir=datadir,sky=float(skys)
          
;print the same commands to a file
          
          sep='    '
          printf,2,ide+sep+image_new+string(xc+1)+string(yc+1)+$
                 sep+pas+sep+incs+sep+amas+sep+amultis+sep+skys+sep+dskys+sep+$
                 mask_new+sep+sigma_fits+sep+psf

          cmd="make_sigma_image_new,'"+data_fits+"','"+mask_fits+"','"+$
              weight_fits+"','"+sigma_fits+$
              "',check=["+string(xc)+","+string(yc)+$
              ",10],fudge=2,datadir='"+datadir+"'"+",sky="+skys
          printf,3,cmd
          
       endif
skip:
    endwhile
    
endi: 
    close,1
    close,2
    printf,3,'end'
    close,3
   
    print,'-------------------------------------------------------------------'
    print,'CONVERTED ',infile,' --> ',outfile
    print,'(contains the names of  SIGMA fits-files)'
    print,''
    print,'REMEMBER TO CHECK THE SIGMA FITS_FILES!'
    print,'.run ',driverfile
 end
