pro check_mask,ima_fits,mask_fits,weight=weight,scale0=scale0

ima=readfits(ima_fits,h)
mask=readfits(mask_fits)

scale=1
if(keyword_set(scale0)) then scale=scale0

if(scale ne 1) then begin
   ima=shrink(ima,f=scale)
   mask=shrink(mask,f=scale)
endif


nx=sxpar(h,'naxis1')/scale
ny=sxpar(h,'naxis2')/scale
nwin_hs,xs=nx*2,ys=ny*2


tvscl,alog(sigrange(nan_to_median(ima))>0.00001),0
tvscl,1.-(mask<1),1
tvscl,alog((1-(mask<1))*sigrange(nan_to_median(ima))>0.00001),2
xyouts,nx*1.1,ny*.9,ima_fits,/dev,chars=.8
xyouts,nx*1.1,ny*.8,mask_fits,/dev,chars=.8
xyouts,nx*1.1,ny*.7,'scale='+string(scale),/dev

return
end
