;------------------------------------------------------
;ngc1097_examples.pro
;------------------------------------------------------
;the plots in the galfidl_manual.pdf are made with this procedure
;writes to ps-files instead of screen


;basic example - makes profile + residual plots
galfit_display_new,'ngc1097_example.ingal',profile=-2,/residual,/restore,/ps


;profile with xlog
galfit_display_new,'ngc1097_example.ingal',profile=-2,/restore,/ps,/xlog,addps='_xlog'


;profile with xlog  in arcsec scale + residual plot in arcsec scale
galfit_display_new,'ngc1097_example.ingal',profile=-2,/restore,/resi,/ps,/xlog,/arcsec,addps='_xlog_arcsec'


;total major and minor axis profiles (major axis along the assumed disk nodal line)
galfit_display_new,'ngc1097_example.ingal',majorminor=999,/restore,/ps

;major axis profiles for all component (along the assumed disk nodal line)
galfit_display_new,'ngc1097_example.ingal',pa=999,/restore,/ps


;make iteration, display results on screen
;may take time!  (22 iterations took 192 seconds in ikiturso)

;IF YOU HAVE ALREADY MADE THE ITERATION, THEN COMMENT OUT THE NEXT
;LINE TO SAVE TIME

galfit_display_new,'ngc1097_example.ingal',/run

;redisplay iteration results
;without ps -> screen
;ps=1  -> eps and pdf files (making pdf is slow and the files are large)
;ps=2  ->  ps and png   BETTER OPTION!  ps=-2 -> timestamp on the
;plots


galfit_run_new,'ngc1097_example',ps=-2




;call browser to view the output png-files

cmd='firefox *ngc1097_example_*png &'
spwan,cmd


;results stored to 
restore,'ngc1097_example.outgal_subcomps.save',/v

end
