pro tabulate_f,x0,y0,x1,x2,dx,xt,yt,myt=myt,dyt=dyt,$
velo=velo,t=t,vv=vv,mv=mv,dmin0=dmin0,ind=ind,mini=mini,maxi=maxi,$
finite=finite,bad=bad


if(n_params() le 0) then begin
    print,'tabulate_f,x,y,x1,x2,dx,xt,yt,myt=myt,dyt=dyt'
    print,'tabulate x,y points according to x'
    print,'interval from x1 to x2 with binsize dx'
    print,'yt(xt) returns histogram of y vs x'
    print,'myt(xt), dyt(xt) mean and stdev of y'
    print,'velo=[vx,vy,vz] -> t=t => 3D temperature, vv=velocity ellipsoid'
    print,'                   mv=mean velo'
    print,'ind=array -> choose only these particles'
    print,'mini,maxi'
    print,'(EFFICIENT: uses histogram function with reverse_index-keyword)'
    print,'example::'
    print,'tabulate_f,xx,vx,-xl,xl,xl/100.,xt,yt,myt=myt,dyt=dyt'
return
endif

x=reform(x0)
y=reform(y0)
if(keyword_set(ind)) then begin
print,'ind:',n_elements(x),' -> ',n_elements(ind)
x=x(ind)
y=y(ind)
endif

dmin=2
if(keyword_set(dmin0)) then dmin=dmin0

nbins=(x2-x1)/dx
xt=findgen(nbins)*dx+0.5*dx+x1  ; centers of bins

;print,!stime



num=lonarr(nbins)
num=histogram(x,min=x1,max=x2,binsize=dx,reverse=r,/nan)
num=num(0:nbins-1)
dnum=0.*num
mnum=0.*num
if(keyword_set(velo)) then begin
    vx=velo(0,*)
    vy=velo(1,*)
    vz=velo(2,*)
    hlp,vx
    hlp,vy
    hlp,vz
    t=0.d0*num
    vv=fltarr(3,3,nbins)
    mv=fltarr(3,nbins)
endif

mini=dnum
maxi=dnum
for i=0l,nbins-1l do begin
    nr=r(i+1)-r(i)
    if(nr ge 2) then begin
        rr=r(r(i):r(i+1)-1)

        if(keyword_set(finite)) then begin
           lok=where(finite(y(rr)) eq 1, nok)
           

;           num_y=n_elements(y(rr))
;           if(nok ne num_y) then begin
;              print,num_y,stdev(y(rr)),nok,stdev(y(rr(lok)))
;           endif
              if(nok ge 2) then rr=rr(lok)
        endif


        if(keyword_set(bad)) then begin
           count1=n_elements(rr)
           lok=where(y(rr) ne bad, nok)
           if(nok ge 2) then rr=rr(lok)
           count2=n_elements(rr)
;           if(count1 ne count2) then print,count1,count2
        endif



        mnum(i)=mean(y(rr))
        if(nr ge dmin) then begin
            dnum(i)=stdev(y(rr))
            maxi(i)=max(y(rr))
            mini(i)=min(y(rr))
            if(keyword_set(velo)) then begin
                tx=stdev(vx(rr))
                ty=stdev(vy(rr))
                tz=stdev(vz(rr))
                t(i)=tx^2+ty^2+tz^2
                txx=mean(vx(rr)^2)-mean(vx(rr))^2
                tyy=mean(vy(rr)^2)-mean(vy(rr))^2
                tzz=mean(vz(rr)^2)-mean(vz(rr))^2
                txy=mean(vx(rr)*vy(rr))-mean(vx(rr))*mean(vy(rr))
                txz=mean(vx(rr)*vz(rr))-mean(vx(rr))*mean(vz(rr))
                tyz=mean(vy(rr)*vz(rr))-mean(vy(rr))*mean(vz(rr))
                vv(0,0,i)=txx
                vv(1,1,i)=tyy
                vv(2,2,i)=tzz
                vv(0,1,i)=txy
                vv(1,0,i)=txy
                vv(0,2,i)=txz
                vv(2,0,i)=txz
                vv(1,2,i)=tyz
                vv(2,1,i)=tyz
                mv(0,i)=mean(vx(rr))
                mv(1,i)=mean(vy(rr))
                mv(2,i)=mean(vz(rr))
            endif
        endif
    endif
endfor
;print,!stime

yt=1.*num
dyt=dnum
myt=mnum
goto,endi

yt=xt*0.
myt=yt*0.
dyt=yt*0.
apu=(x-x1)/dx
mini=yt
maxi=yt
for i=0l,nbins-1l do begin
;xmin=xt(i)-dx/2.
;xmax=xt(i)+dx/2.
;ind=where(x ge xmin and x lt xmax,count)
    ind=where(apu ge i and apu lt i+1,count)
    if(count ge 1) then begin
        yt(i)=1.*count
        maxi(i)=max(y(ind))
        mini(i)=min(y(ind))
        myt(i)=total(y(ind))/count
        if(count ge dmin) then dyt(i)=stdev(y(ind))
    endif
endfor
print,!stime
endi:
end 















