;--------------------------------------------------------------------
 pro s4g_p2_check_driver_f,infile,datalist0,files0=files0,check=check,$
                           wait=wait,ps=ps
;--------------------------------------------------------------------

if(n_params() le 0) then begin
   print,'--------------------------------------------------------'
   print,' s4g_p2_check_driver_f,infile,datalist0'
   print,'--------------------------------------------------------'
   print,' FIRST PROCEDURE TO CALL IN PIPELINE3:'
   print,'   read a list of galaxy identifications from infile'
   print,'   fetch P1 image and P2 params --> write to datalist0-file'
   print,' CAN ALSO BE USED FOR CHECKING ISOPHOTES - keyword check'
   print,'   check=1 -> also plot the isophotes on top of images'
   print,'   check=2 -> just plot the isophotes on top of images'
   print,'              do not write datalist0'
   print,'   wait=1   -> wait between plots'
   print,'   /ps      -> write  to ps and png-files instead of screen'
   print,'--------------------------------------------------------'
   print,' FORMAT OF INFILE:'
   print,'   1 entry per line (eg. NGC0300), line starting with # ignored'
   print,'   list of files can also be given via keyword (files=strarr)'
   print,'---------------------------------------------------------'
   print,' Currently works only for 3.6 micron ARCHIVAL DATA:'
   print,' assumes that data is at'
   print,"   S4G_DIR='~/S4G/PRODUCTS/ARCHIVAL/'"
   print,"   datadir=S4G_DIR+ide+'/P1/'"
   print,"   image_file=datadir+ide+'.phot.1.fits'"
   print,"   profdir=S4G_DIR+ide+'/P2/'"
   print,'--------------------------------------------------------'
   print,' heikki.salo@oulu.fi / 191209'
   print,'--------------------------------------------------------'
   return 
endif

  nocheck=1
  if(keyword_set(check)) then nocheck=0

;---------------------------------------------------------
;read form infile?

  if(not keyword_set(files0)) then begin
     close,1
     openr,1,infile
     line=''
     files=''
     while not eof(1) do begin
        readf,1,line
        if(strpos(line,'#') eq -1) then files=[files,strtrim(line,2)]
     endwhile
     files=files(1:*)
  endif

;via keyword
  if(keyword_set(files0)) then files=files0


;---------------------------------------------------------
;arrays for storing isophote information for each galaxy

  nfiles=n_elements(files)
  xctab=fltarr(nfiles)
  yctab=xctab
  patab=xctab
  elltab=xctab
  smatab=xctab
  imagetab=strarr(nfiles)
  
  for i=0,n_elements(files)-1 do begin


     if(keyword_set(ps) and nocheck eq 0) then psdirect,files(i)+'_isocheck',-2,/color

     S4G_P2_CHECK,files(i),xc0=xc0,yc0=yc0,pa0=pa0,ellip0=ellip0,sma0=sma0,$
                  image_file=image_file,nocheck=nocheck

     if(keyword_set(ps) and nocheck eq 0) then psdirect,files(i)+'_isocheck',-2,/color,/stop

     xctab(i)=xc0
     yctab(i)=yc0
     patab(i)=pa0
     elltab(i)=ellip0
     smatab(i)=sma0

     if(keyword_set(check) and keyword_set(wait)) then begin
        vast=''
        read,vast
        wide
     endif

  endfor
  
  
;----------------------------------------------------------------
;For making s4g_pipeline2_template.datalist0
;copy to proper datalist0 name after editing disk ellipticities etc.
;When writing ingal-files, default cutting= A26p5*AMULT pixels
;----------------------------------------------------------------

  if(keyword_set(check)) then begin
     if(check eq 2) then goto,endi
  endif


  close,1
  openw,1,datalist0
  printf,1,'version=1'
  printf,1,'# ============================================================'
  printf,1,'# Interface between pipelines 2 and 3'
  printf,1,'# datalist0-file made from infile= '+infile
  printf,1,'# '+mywhoami()+'@'+hostname(),'    ',!stime
  printf,1,'# ============================================================'
  printf,1,'# IDE  image  XC(iraf)  YC(iraf)  PA  ELLIP  A26p5  AMULT '+$
         '    mask  weight(sigma)    psf' 
  printf,1,'#'
  for i=0,nfiles-1 do begin        
     sep='  '
     ide=files(i)+'_36'+sep
     imagefits=files(i)+'.phot.1.fits'+sep
     xc=string(xctab(i),'(f10.3)')+sep
     yc=string(yctab(i),'(f10.3)')+sep
     pa=string(patab(i),'(f10.2)')+sep
     ell=string(elltab(i),'(f10.4)')+sep+sep
     sma=string(smatab(i),'(f10.1)')+sep+sep+'1.3'+sep+sep
     maskfile=files(i)+'.1mask.fits'+sep
     wtfile=files(i)+'.phot.1_wt.fits'+sep
     psffile='psf.fits'
     printf,1,ide+imagefits+xc+yc+pa+ell+sma+maskfile+wtfile+psffile
  endfor     
  close,1

 
endi:
end
