pro s4g_p2_check,ide,xc0=xc0,yc0=yc0,pa0=pa0,ellip0=ellip0,sma0=sma0,$
                 stop0=stop0,nocheck=nocheck,image_file=image_file


if(n_params() le 0) then begin
   print,'----------------------------------------------------------------'
   print,' s4g_p2_check,ide,xc=xc,yc=yc,pa=pa,ellip=ellip,sma=sma,$'
   print,'             stop=stop,nocheck=nocheck'
   print,'----------------------------------------------------------------'
   print,' subroutine for                                                 '
   print,' 1) reading P2 data (currently 3.6micron band)                  '
   print,'    ide ->  xc,yc,pa,ellip,sma   [center, PA, 1-b/a, a26.5(pix)]'
   print,' 2) checking P2 isophotal fits ( unless /nocheck)'
   print,'  '
   print,' Called by s4g_p2_check_driver.pro'
   print,'----------------------------------------------------------------'
   print,' heikki.salo@oulu.fi 091209'
   print,'----------------------------------------------------------------'
   return
endif

  S4G_DIR='~/S4G/PRODUCTS/ARCHIVAL/'
  datadir=S4G_DIR+ide+'/P1/'
  image_file=datadir+ide+'.phot.1.fits'
  profdir=S4G_DIR+ide+'/P2/'

;-------------------------------------------------------
;26.5 structural params

  f26p5=profdir+ide+'.26p5.dat'
  close,33
  openr,33,f26p5
  readf,33,ra0, dec0, pa0, sma0, ellip0
  sma0=sma0/0.75                ;in pixels

;---------------------------------------------
;free ellipse-fits with 2 arcsec and 6 arcsec bins
; in 3.6 micron band
;---------------------------------------------

  tabfile2=profdir+ide+'.1fr2a_obs.dat'
  tabsave2=ide+'.1fr2a_obs.save'
  tabfile6=profdir+ide+'.1fr6a_obs.dat'
  tabsave6=ide+'.1fr6a_obs.save'
  tabfile20=tabfile2
  tabfile60=tabfile6

;subroutine for reading P2 tables
  s4g_pae_plot,tabfile20,/clean,/nopl,save=tabsave2
  s4g_pae_plot,tabfile60,/clean,/nopl,save=tabsave6

  restore,tabsave6
  xc0=x0(0)
  yc0=y0(0)

  if(keyword_set(nocheck)) then goto,endi

;----------------------------------------------------------
;plot isophotes on top of image + 
;radial profiles of mag, ellip, pa


;plot image with tvplot2

  ima=readfits(image_file,h)
  nwin_hs
  !p.multi=[0,2,1]
  loadct,0
  f50='(f5.0)'
  f51='(f5.1)'
  f52='(f5.2)'

  nx=n_elements(ima(*,0))
  ny=n_elements(ima(0,*))
  xx=findgen(nx)-xc0
  yy=findgen(ny)-yc0
  scale=4
  ima=shrink(ima,f=scale)
  xx=shrink(xx,f=scale)
  yy=shrink(yy,f=scale)  
  tvplot2,-alog(ima>0.00001),title=ide,/asp,/nonew,xx=xx,yy=yy,col=2
  
;overplot 6arcsec bin isophotes 26.5, 25.5, ..

  indtab=lonarr(8)
  for i=0,7 do begin
     diff=abs(sb_cor-(26.5-i))
     use=where(diff eq min(diff))
     use=use(0)
     indtab(i)=use
     a=sma(use)
     
     b=a*(1.-ellip(use))
     xc=x0(use)
     yc=y0(use)
     fii=pa(use)+90
  
;subroutine for plotting ellipse   
     ellipse_f,a,b,xc-xc0,yc-yc0,fii,200,xe,ye
     tek_color
     oplot,xe,ye,col=5
  endfor
  

  !p.charsize=1.4
  if(!d.name eq 'PS') then !p.charsize=1.


;magnitude profile

  !p.multi=[5,2,4]
  restore,tabsave6
  plot,sma(1:*),sb_cor(1:*),xr=[0,sma0*1.5],xs=1,psym=0,syms=.2,$
       xtitle='pix',ytitle='mu3.6',yr=[32,16],chars=!p.charsize,/nod
  oplot,sma(1:*),sb_cor(1:*),col=5
  oplot,sma(1:*),sb_cor(1:*)+esb_cor(1:*),col=5
  oplot,sma(1:*),sb_cor(1:*)-esb_cor(1:*),col=5
  oplot,[1,1]*sma0,[0,100],lines=0,col=2
  oplot,[.75,1.25]*sma0,[1,1]*26.5,lines=0,col=2,thick=3
  oplot,sma(indtab),sb_cor(indtab),psym=6,syms=1,col=5
  restore,tabsave2
  oplot,sma(1:*),sb_cor(1:*),col=3,psym=6,syms=.2
  
  
;ellipticity profile

  !p.multi=[3,2,4]
  restore,tabsave6
  plot,sma(1:*),ellip(1:*),xr=[0,sma0*1.5],xs=1,psym=0,syms=.2,$
       xtitle='pix',ytitle='ell',chars=!p.charsize,/nod
  oplot,sma(1:*),ellip(1:*),col=5
  oplot,[1,1]*sma0,[0,1],lines=0,col=2
  oplot,[.75,1.25]*sma0,[1,1]*ellip0,lines=0,col=2,thick=3
  oplot,sma(indtab),ellip(indtab),psym=6,syms=1,col=5
  restore,tabsave2
  oplot,sma(1:*),ellip(1:*),col=3,psym=6,syms=.2

  
;position angle profile

  !p.multi=[1,2,4]
  restore,tabsave6
  plot,sma(1:*),pa(1:*),xr=[0,sma0*1.5],xs=1,psym=0,syms=.2,$
       xtitle='pix',ytitle='pa',chars=!p.charsize,/nod
  oplot,sma(1:*),pa(1:*),col=5
  oplot,sma(1:*),pa(1:*)-180,col=5
  oplot,sma(1:*),pa(1:*)-180*2,col=5
  oplot,sma(1:*),pa(1:*)+180,col=5
  oplot,sma(1:*),pa(1:*)+180*2,col=5
  
  oplot,[1,1]*sma0,[-1000,1000],lines=0,col=2
  oplot,[.75,1.25]*sma0,[1,1]*pa0,lines=0,col=2,thick=3
  oplot,sma(indtab),pa(indtab),psym=6,syms=1,col=5
  
  restore,tabsave2
  oplot,sma(1:*),pa(1:*),col=3,psym=6,syms=.2
  
  !p.multi=0
  !p.charsize=0

;titles on the plot
  
  title_265='pa0='+string(pa0,f51)+'  SMA0(pix)='+string(sma0,f50)+$
            '  ELLIP0='+string(ellip0,f52)

  dy=0.01
  xyouts,0.1,0.94+dy,IDE+'    (s4g_p2_check.pro  '+!stime+')',/nor,chars=1.
  xyouts,0.1,0.91+dy,title_265,col=2,/nor,chars=1.  
  xyouts,0.1,0.87+dy,image_file,/nor,chars=.75
  xyouts,0.1,0.85+dy,f26p5,/nor,col=2,chars=.75
  xyouts,0.1,0.83+dy,tabfile6,/nor,col=5,chars=.75
  xyouts,0.1,0.81+dy,tabfile2,col=3,/nor,chars=.75

endi:
if(keyword_set(stop0)) then stop

end
