;-------------------------------------------------
 pro s4g_mask_check_driver_f,infile,choose=choose,$
                             wide=wide,scale0=scale0
;-------------------------------------------------

if(n_params() le 0) then begin
   print,'--------------------------------------------'
   print,' s4g_mask_check_driver_f,infile,datalist0'
   print,'--------------------------------------------'
   print,' PIPELINE3: optional check of mask files'
   print,'   read a list of galaxy identifications from infile'
   print,'   fetch P1 image and mask + display them one-by-one'
   print,''
   print,' Format of infile:'
   print,'   one entry per line (e.g. NGC0300), lines starting with # ignored'
   print,''
   print,' KEYWORDS:'
   print,'   choose=string -> check only Galaxy ID contains string'
   print,'   /wide ->        clear screen after each galaxy'
   print,'   scale = factor  change scale of plots'
   print,''
   print,'--------------------------------------------'
   print,' Currently work for 3.6 micron: assumes that data is found at'
   print,"   S4G_DIR='~/S4G/PRODUCTS/ARCHIVAL/'"
   print,"   datadir=S4G_DIR+ide+'/P1/'"
   print,"   image_file=datadir+ide+'.phot.1.fits'"
   print,"   mask_file=datadir+ide+'.1mask.fits'"
   print,"   profdir=S4G_DIR+ide+'/P2/'"
   print,'--------------------------------------------------------'
   print,' heikki.salo@oulu.fi / 191209'
   print,' --------------------------------------------------------'   
return 
endif



close,1
openr,1,infile
line=''
files=''
while not eof(1) do begin
   readf,1,line
   if(strpos(line,'#') eq -1) then files=[files,strtrim(line,2)]
endwhile
files=files(1:*)


S4G_DIR='~/S4G/PRODUCTS/ARCHIVAL/'


 nfiles=n_elements(files)

 for i=0,n_elements(files)-1 do begin
    ide=files(i)

    if(keyword_set(choose)) then begin
       junk=strpos(ide,choose)
       if(junk eq -1) then goto,skip
    endif


    datadir=S4G_DIR+ide+'/P1/'
    image_file=datadir+ide+'.phot.1.fits'
    mask_file=datadir+ide+'.1mask.fits'
  

    print,image_file
    print,mask_file

    ima=readfits(image_file,h,/silent)

    nx=sxpar(h,'naxis1')
    scale=1.    
    fac=1.
    if(keyword_set(scale0)) then fac=scale0
    if(nx gt 200*fac) then scale=nint(nx/200./fac)
    check_mask,image_file,mask_file,scale=scale
    
    vast=''
    read,vast
    if(keyword_set(wide)) then wide

    skip:
 endfor

end
