;---------------------------------------------------------
  pro pipeline_2to3_interface_f_new,datalist_ide
;---------------------------------------------------------
;subroutine version of pipeline_2to3_interface.pro

    if(n_params() le 0) then begin
       print,'---------------------------------'
       print,'pipeline_2to3_interface_f_new,ide'
       print,'---------------------------------'
       print,'PIPELINE3: second procedure to call'
       print,'writes ide.datalist0 -> ide.datalist'
       print,'makes the needed sigma, nonan-image, and new-mask'
       print,' '
       print,' ide.datalist:'
       print,' #-marks comment lines - do not include these'
       print,' ##-skip the rest'
       print,'---------------------------------'
       print,' heikki.salo@oulu.fi 10.12.2009'
       print,'---------------------------------'
       return
    endif
    
;Two-fold purpose:
;1) make datalist-file for the creation of galfit input parameter files
;   and make the needed sigma-, nonan- images

;2) write a separate driver-procedure for making the sigma images 
;   = 'make_sigma_image_driver.pro'
;      this can be run separately to get visual check of sigma-images
    
;read from pipeline2.datalist0 -> pipeline2.datalist
;replace weight images with the calculated sigma-images
;replace image and mask to new files with NaN's removed 
;set exptime=1


    S4G_DIR='~/S4G/PRODUCTS/ARCHIVAL/'
    infile=datalist_ide+'.datalist0'
    outfile=datalist_ide+'.datalist'
    driverfile=datalist_ide+'_make_sigma_driver.pro'
    
    close,1
    openr,1,infile
    
    close,2
    openw,2,outfile,wid=120
    
    close,3
    openw,3,driverfile,wid=120
    
    line=''
    readf,1,line                ;version line
    printf,2,line 
    printf,2,'# ============================================================'
    printf,2,'# Interface between pipelines 2 and 3'
    printf,2,'# datalist-file made from infile= '+infile
    printf,2,'# '+mywhoami()+'@'+hostname(),'    ',!stime
    printf,2,'# ============================================================'
    printf,2,'# IDE  image  XC(iraf)  YC(iraf)  PA  ELLIP  A26p5  AMULT '+$
           '    mask  sigma    psf' 
    printf,2,'#'
 
;comment lines
    while not eof(1) do begin
       
       readf,1,line
       start=strmid(line,0,1)
       if(strmid(line,0,2) eq '##') then goto,endi
       if(line ne '' and strmid(line,0,1) ne '#') then begin ;not a comment
          
          print,line
          res=strsplit(line,/extr)
          ide=res(0)
          data_fits=res(1)
          xc=float(res(2))-1.   ;iraf --> idl
          yc=float(res(3))-1.   ;iraf --> idl
          pas=res(4)
          incs=res(5)
          amas=res(6)
          amultis=res(7)
          mask_fits=res(8)
          weight_fits=res(9)
          psf=res(10)
          
;build directory path to original data
          sep=strpos(ide,'_')
          idegal=strmid(ide,0,sep)
          datadir=S4G_DIR+idegal+'/P1/'
             
;make_sigma_image.pro:
; nonan indicates than NaNs have been removed from the image
; and marked in the new mask image
; also set EXPTIME keyword to unity
          
          mask_new=remove_tag(mask_fits)+'_nonan.fits'
          image_new=remove_tag(data_fits)+'_nonan.fits'
          sigma_fits=remove_tag(data_fits)+'_sigma.fits'
          
;make them
          
          make_sigma_image_new,$
             data_fits, mask_fits, weight_fits, sigma_fits, $
             fudge=2, mask=mask_new, image=image_new,datadir=datadir
          
;print the same commands to a file
          
          sep='    '
          printf,2,ide+sep+image_new+string(xc+1)+string(yc+1)+$
                 sep+pas+sep+incs+sep+amas+sep+amultis+sep+$
                 mask_new+sep+sigma_fits+sep+psf

          cmd="make_sigma_image_new,'"+data_fits+"','"+mask_fits+"','"+$
              weight_fits+"','"+sigma_fits+$
              "',check=["+string(xc)+","+string(yc)+$
              ",10],fudge=2,datadir='"+datadir+"'"
          printf,3,cmd
          
       endif
skip:
    endwhile
    
endi: 
    close,1
    close,2
    printf,3,'end'
    close,3
   
    print,'-------------------------------------------------------------------'
    print,'CONVERTED ',infile,' --> ',outfile
    print,'(contains the names of  SIGMA fits-files)'
    print,''
    print,'REMEMBER TO CHECK THE SIGMA FITS_FILES!'
    print,'.run ',driverfile
 end
