;*************************************
pro image_bilin,image,xx,yy,adu,badval=badval,check=check
;*************************************

if(n_params() le 0) then begin
    print,'pro image_bilin,image,xx,yy,adu'
    print,' '
    print,'bilinear interpolation of ADU values at points XX,YY of IMAGE'
    print,'lower-left corner=(0,0), upper-right corner (nx-1,ny-1)
    print,'xx<0 or xx>nx-1 -> value = -1 outside image'
    print,'yy<0 or yy>ny-1 -> value = -1 outside image'
    print,' '
    print,'badval=value : image(adjacent point)=badval -> set adu=-2 '
    return
endif

nx=n_elements(image(*,0))
ny=n_elements(image(0,*))
;print,nx,ny

adu=xx*0.-1.
acc=where(xx ge 0 and xx le nx-1 and yy ge 0 and yy le ny-1,count)

if(count ge 1) then begin
    for i=0l,count-1 do begin
        xp=xx(acc(i))
        yp=yy(acc(i))

        ix=1.*fix(xp)
        iy=1.*fix(yp)
        jx=ix+1.<(nx-1)
        jy=iy+1.<(ny-1)
        dx=xp-ix
        dy=yp-iy
        tx=1.-dx
        ty=1.-dy
        bad=0
        
        if(keyword_set(badval)) then begin
            if(image(jx,jy) eq badval) then bad=1
            if(image(jx,iy) eq badval) then bad=1
            if(image(ix,jy) eq badval) then bad=1
            if(image(ix,iy) eq badval) then bad=1
        endif
        
        if(bad eq 0) then begin
            adu(acc(i))=dx*dy*image(jx,jy)+dx*ty*image(jx,iy)+tx*dy*image(ix,jy)+tx*ty*image(ix,iy)
        endif
        if(bad eq 1) then adu(i)=-2.
        if(keyword_set(check)) then begin
            print,'xp,yp',xp,yp
            print,ix,iy,jx,jy
            print,dx,dy,tx,ty
            print,'adut:'
            print,image(ix,jy),image(jx,jy)
            print,image(ix,iy),image(jx,iy)
        endif
        
    endfor
endif


end
