pro galfit_iterate,infile,outfile0,structure0=structure0,new=new,$
                   ok=ok,galfit_res=galfit_res,silent=silent
  
  if(n_params() le 0) then begin
     print,'----------------------------------------------------'
     print,'galfit_iterate,INFILE,OUTFILE'
     print,'----------------------------------------------------'
     print,'make GALFIT iteration, parameters read from INFILE'
     print,'                       output parameters to OUTFILE'
     print,''
     print,'if OUTFILE omitted -> parsed from INFILE:'
     print,'e.g. ngcXXXX_model.ingal --> ngcXXXX_model.outgal' 
     print,'----------------------------------------------------'
     print,'input keywords:'
     print,'STRUCTURE  = list of component ide-strings'
     print,'             def = given in INFILE (by STRUCTURE lines)'
     print,'/NEW       = make new iteration even if OUTFILE exists' 
     print,'             (default is to return without doing iteration)'
     print,'output keywords:'
     print,'OK=OK      returns output status:'
     print,'    1         galfit succeeds -> new outgal'
     print,'    0         using previously created outgal (not keyword /new)'
     print,'   -1         galfit crashed  -> no outgal'
;     print,'GALFIT_RES  returns galfit-output'
     print,'----------------------------------------------------'
     print,'example:'
     print,"galfit_iterate,'ngc4594_bulgetest.ingal'"
     print,'----------------------------------------------------'
     print,' HS 210909'
     return
  endif


info=0


;------------------------------------------------------------
; 1) read infile
;------------------------------------------------------------
; usually ngcXXXX.ingal containing optional STRUCTURE lines
; --> this information is displayed in the plot 
;
; If STRUCTURE lines not found, then  comp=1, comp=2 etc are used
;------------------------------------------------------------

  if(n_params() eq 2) then outfile=outfile0
  if(n_params() lt 2) then outfile=remove_tag(infile,tag='.ingal')+'.outgal'

  

   close,1
   openr,1,infile
   line=''

;the following data will be read from infile
   data_image='unknown'
   out_image='unknown' 
   sigma_image='none'
   psf_image='none'
   mask_image='none'
   xc=-1.
   yc=-1.
   zeropoint=18.32
   string_comps=' '
   
   mui_pos=-1                     
   while not eof(1) do begin
      readf,1,line

;searching STRUCTURE lines = optional comment lines in ingal-file
;identifying the structure component

      if(strpos(line,'STRUCTURE') ne -1 and strpos(line,'STRUCTURE') le 5) $
      then begin
         apu=str_sep(line,' ') & apu=apu(where(apu ne ''))
         string_comps=[string_comps,apu(2)]
;         print,line
      endif

;searching standard galfit input lines
      
      if(strpos(line,'A)') ne -1 and strpos(line,'A)') le 2)then begin
         apu=str_sep(line,' ') & apu=apu(where(apu ne ''))
         data_image=apu(1)
      endif
      if(strpos(line,'B)') ne -1) then begin
         apu=str_sep(line,' ') & apu=apu(where(apu ne ''))
         out_image=apu(1)
      endif
      if(strpos(line,'C)') ne -1) then begin
         apu=str_sep(line,' ') & apu=apu(where(apu ne ''))
         sigma_image=apu(1)
      endif
      if(strpos(line,'D)') ne -1) then begin
         apu=str_sep(line,' ') & apu=apu(where(apu ne ''))
         psf_image=apu(1)
      endif
      if(strpos(line,'F)') ne -1) then begin
         apu=str_sep(line,' ') & apu=apu(where(apu ne ''))
         mask_image=apu(1)
      endif
      if(strpos(line,'J)') ne -1) then begin
         apu=str_sep(line,' ') & apu=apu(where(apu ne ''))
         zeropoint=float(apu(1))
      endif
     
;searching center position of the FIRST component,
;used in all profile plots
      
      npos=strpos(line,'1)')
      npos2=strpos(line,'osition')
      if(mui_pos eq -1 and npos ne -1 and npos le 2 and npos2 ne -1) then begin
         apu=str_sep(line,' ') & apu=apu(where(apu ne ''))
         xc=float(apu(1))
         yc=float(apu(2))
         mui_pos=1
      endif
   endwhile
   

   print,'----------------------------------------'
   print,'Read input-file  = ',infile

   if(info ge 1) then begin
      print,'----------------------------------------'
      print,'data_image  = ',data_image
      print,'out_image   = ',out_image
      print,'sigma_image = ',sigma_image
      print,'psf_image   = ',psf_image
      print,'mask_image  = ',mask_image
      print,'----------------------------------------'
      print,xc,yc
   endif

   if(keyword_set(structure0)) then begin
      print,'STRUCTURE names given via call keyword'
      string_comps=structure0
   endif

   ncomp1=n_elements(string_comps)-1
   if(ncomp1 ge 1) then begin
      string_comps=string_comps(1:ncomp1)
      print,string_comps
   endif
;   print,'----------------------------------------'
   

;-------------------------------------------------
;2 Iteration with galfit?
; - GALFIT makes an output parameter file galfit.NN,
;   where NN is a running number
; - Copy this file into OUTFILE, and add the STRUCTURE -lines
;   from INFILE
   

;2a) call galfit to make the fit
;NOT if outfile exists and keyword new is not sent
   
   ok=0                     ;defaut=existing outgal

   if(not keyword_set(new)) then begin
      close,22
      openr,22,outfile,error=STAT
      IF(STAT EQ 0) THEN begin
         print,outfile,'  exist, no iteration needed -> return'
         return
      endif
   endif

   
   print,'START GALFIT ITERATION'
   junk1=bin_date()
   cmd='galfit '+infile
   ;spawn,cmd,galfit_res,exit=galfit_exit
   spawn,cmd,exit=galfit_exit

   
;crashes?
   if(galfit_exit ne 0) then begin
      PRINT,'GALFIT CRASHES -> exit'
      ok=-1                     ;new outgal is not created   
      return
   endif

   ok=1                     ;new outgal will be created

   junk2=bin_date()
   elapsed=junk2(5)-junk1(5)+60.*(junk2(4)-junk1(4))+3600.*(junk2(3)-junk1(3))
   print,'GALFIT ITERATION required ',elapsed, ' wall-clock seconds'





    
;2b) find the newly-created galfit.NN output-name 

   find_galfitnn,galfit_nn      ;returns the most recent galfit.nn

;2ccopy to proper-output name + insert STRUCTURE-keywords

   copy_galfitnn_outgal,galfit_nn,outfile,string_comps=string_comps


;check
;   cmd='head -2 '+outfile
;   spawn,cmd
;   print,infile

end
