;********************************
pro ellipse_f,a,b,xc,yc,fii,n,xe,ye,plot=plot,oplot=oplot,pa=pa,eano=eano
;********************************

if(n_params() eq 0) then begin
print,'pro ellipse_f,a,b,xc,yc,fii,n,xe,ye,/plot,/oplot,pa=pa'
print,'creates ellipse'
print,'if b<0 b=eks'
print,'pa=PA ccw from North in degrees (overrides fii)' 
return
endif

if(b le 0) then b=a*sqrt(1.-b*b)

e=2.*!pi*indgen(n+1)/n
eano=e
sine=sin(e)
cose=cos(e)
xtemp=a*cose
ytemp=b*sine

if(not keyword_set(pa)) then begin
   cosf=cos(!pi/180.*fii)
   sinf=sin(!pi/180.*fii)
   xe=xc+cosf*xtemp-sinf*ytemp
   ye=yc+cosf*ytemp+sinf*xtemp
endif
if(keyword_set(pa)) then begin
   cosp=cos(!pi/180.*(pa+90.))
   sinp=sin(!pi/180.*(pa+90.))
   xe=xc+cosp*xtemp-sinp*ytemp
   ye=yc+cosp*ytemp+sinp*xtemp
endif

if(keyword_set(plot)) then plot,xe,ye
if(keyword_set(oplot)) then oplot,xe,ye
end



























