;-------------------------------------------------------------
;datalist_to_ingal_driver.pro
;-------------------------------------------------------------
pro datalist_to_ingal_driver_f,datalistide

  if(n_params() le 0) then begin
     print,'--------------------------------------'
     print,'datalist_to_ingal_driver_f,datalistide'
     print,'--------------------------------------'
     print,''
     print,'makes simple ingal-files for galaxies listed in datalistide'
     print,'example:'
     print,"datalist_to_ingal_driver_f,'s4g_pipeline2_test081209'"
     print,'heikki.salo@oulu.fi   081209'
     return
  endif


;make galfit input parameter files
;for "10galaxies"
;creates b, bd, bdbarnmodel

;------------------------------------------------------
;read datalist-file containing pipeline 1&2 parameters
; eq. infile='pipe3_example.datalist'

;runfile = write idl-driver procedure for making the
;          GALFIT interations with the INGAL's created here


  infile=datalistide+'.datalist'
  print,infile

  runfile=datalistide+'_driver.pro'
  print,runfile

  close,1
  openr,1,infile

  close,2
  openw,2,runfile
  printf,2,';Automatically generated driver-procedure'
  printf,2,';'+!stime
  printf,2,'new=1'
  printf,2,'ps=0'
  printf,2,'  '



  line=''
  readf,1,line                  ;version line

  while not eof(1) do begin   
     readf,1,line
     start=strmid(line,0,1)
     
     if(strmid(line,0,1) ne '#') then begin ;not a comment 
        print,'------------------------------------------------------------'
        print,line
        print,'------------------------------------------------------------'
        res=strsplit(line,/extr)
        ide=res(0)
        data_fits=res(1)
        xc=float(res(2))-1.
        yc=float(res(3))-1.
        pas=res(4)
        ells=res(5)
        smas=res(6)
        smult=res(7)
        mask_fits=res(8)
        sigma_fits=res(9)
        psf=res(10)

;cut around denter
        cut=float(smas)*float(smult)

        
;make simple ingal files
;-------------------------------------------------------------
;bulge

        ide_use=ide+'_b'      
        datalist_to_ingal,ide_use,data_fits, sigma_fits, mask_fits, psf,$
                          xc_idl=xc,yc_idl=yc,cut=cut

        printf,2,'galfit_run_new,"'+ide_use,'",ps=ps,new=new'

;-------------------------------------------------------------
;bulge+disk

        if(strpos(ells,'zz') eq -1) then begin
           ide_use=ide+'_bd'
           disk=[1.-float(ells),float(pas)]
           datalist_to_ingal,ide_use,data_fits, sigma_fits, mask_fits, psf,$
                             xc_idl=xc,yc_idl=yc,disk=disk,cut=cut

           printf,2,'galfit_run_new,"'+ide_use,'",ps=ps,new=new'

           ide_use=ide+'_bdf'
           disk=[1.-float(ells),float(pas),1]
           datalist_to_ingal,ide_use,data_fits, sigma_fits, mask_fits, psf,$
                             xc_idl=xc,yc_idl=yc,disk=disk,cut=cut

           printf,2,'galfit_run_new,"'+ide_use,'",ps=ps,new=new'
        
        endif

;-------------------------------------------------------------
;bulge+zdisk

        if(strpos(ells,'zz') ne -1) then begin
           ide_use=ide+'_bz'
           zdisk=float(pas)
           datalist_to_ingal,ide_use,data_fits, sigma_fits, mask_fits, psf,$
                             xc_idl=xc,yc_idl=yc,zdisk=zdisk,cut=cut

           printf,2,'galfit_run_new,"'+ide_use,'",ps=ps,new=new'
        endif


;MODEL TEMPLATES FOR CUT/PASTE/EDIT

;-------------------------------------------------------------
;bulge+disk+bar+nuc  model
        if(strpos(ells,'zz') eq -1) then begin
           ide_use=ide+'_bdbarnmodel'
           disk=[1.-float(ells),float(pas)]
           datalist_to_ingal,ide_use,data_fits, sigma_fits, mask_fits, psf,$
                             xc_idl=xc,yc_idl=yc,disk=disk,/bar,/nuc,cut=cut
           printf,2,';galfit_run_new,"'+ide_use,'",ps=ps,new=new'
        endif

;-------------------------------------------------------------
;bulge+zdisk+bar+nuc model
        if(strpos(ells,'zz') ne -1) then begin
           ide_use=ide+'_bzbarnmodel'
           zdisk=float(pas)
           datalist_to_ingal,ide_use,data_fits, sigma_fits, mask_fits, psf,$
                             xc_idl=xc,yc_idl=yc,zdisk=zdisk,/bar,/nuc,cut=cut

           printf,2,';galfit_run_new,"'+ide_use,'",ps=ps,new=new'
        endif



     endif
skip:
  endwhile

  close,1
  printf,2,'end'
  close,2

end
