pro datalist_to_ingal,IDE, data_fits, sigma_fits, mask_fits, psf_fits, $
                      xc_idl=xc_idl, yc_idl=yc_idl,$
                      disk=disk, zdisk=zdisk, bar=bar, nuc=nuc, cut=cut


  if(n_params() le 0) then begin
     print,'-------------------------------_-----------------------------------'
     print,'datalist_to_ingal, IDE, data_fits, sigma_fits, mask_fits, psf_fit,$'
     print,'                   xc_idl=xc_idl,yc_idl=yc_idl,$'
     print,'                   disk=disk,zdisk=zdisk,bar=bar,nuc=nuc, cut=cut'
     print,'-------------------------------------------------------------------'
     print,'make IDE.ingal starting parameter file for galfit'
     print,'  bulge'
     print,'  bulge+disk                if disk  set'
     print,'  bulge+zdisk               if zdisk set'
     print,'  bulge+disk+bar            if disk and /bar '
     print,'  bulge+zdisk+bar           if zdisk and /bar '
     print,'  same but with nucleus     if /nuc ' 
     print,'Needs:'
     print,'  names of data, sigma, mask, and psf-files' 
     print,'  xc,yc (idl-system)'
     print,'  disk=[b/a, PA]   or  [b/a, PA,  free]'      
     print,'                   free=1  -> free ori (def = fixed)'
     print,'  zdisk=[PA]   (always free orientation)'
     print,'  /bar  -> bar'
     print,'  /nuc  -> nucleus'
     print,'---------------------------------------------------------------------'
     print,'this procedure is called normally from a driver-procedure'
     print,'heikki.salo@oulu.fi 230909/201209'
     print,'---------------------------------------------------------------------'
     return
  endif

  print,ide

;-----------------------------------------------------------------------------------
;photometric zeropoint

  pix=0.75
  mu0=20.472-5.*alog10(pix)     ;21.0967
  texp=1.

  i4='(i4)'
  f3='(f9.3)'  

;-------------------------------------------------------------------------------------------------
;read image-data to obtain total magnitude

  ima=readfits(data_fits,header,/sile)
  nx=sxpar(header,'naxis1')  
  ny=sxpar(header,'naxis2')

  mask=readfits(mask_fits,/sile)
  ok=where(mask eq 0)

  magtot=-2.5*alog10(total(ima(ok)))+mu0 ;total magnitude
  sregion=' 1 '+string(nx,i4)+' 1 '+string(ny,i4)

;-------------------------------------------------------------------------------------------------
;center
  xcs=string(xc_idl+1,f3)
  ycs=string(yc_idl+1,f3)


;added 201209
;region extends xc-cut:xc+cut
  if(keyword_set(cut)) then begin
     xmin=xc_idl+1-cut >1
     xmax=xc_idl+1+cut < nx
     ymin=yc_idl+1-cut >1
     ymax=yc_idl+1+cut < ny
     sregion=string(xmin,i4)+'  '+string(xmax,i4)+'  '+string(ymin,i4)+'  '+string(ymax,i4)
  endif

;-------------------------------------------------------------------------------------------------
;find effective radius reff and surface brightness at mu_reff(reff)

  dist_circle,rad,[nx,ny],xc_idl,yc_idl
  ima_use=ima
  bad=where(mask ne 0)
  ima_use(bad)=0.

  ftot=total(ima_use)
  order=sort(rad)
  fcum=0.
  for i=0l,n_elements(rad)-1 do begin
     fcum=fcum+ima_use(order(i))
     if(fcum ge 0.5*ftot) then begin
        reff=rad(order(i))
        mu_reff=-2.5*alog10(ima_use(order(i))/texp)+mu0
        goto,acc
     endif
  endfor
  acc:

  mu_central=-2.5*alog10(mean(ima_use(order(0:10)))/texp)+mu0

  sreff=string(reff,f3)
  smu_reff=string(mu_reff,f3)
                                ;print,'reff   = '+sreff
                                ;print,'mu_reff= '+smu_reff

;-------------------------------------------------------------------------------------------------
; START WRITING ide.ingal

;general part

  close,11
  openw,11,IDE+'.ingal'
  printf,11,'# made by datalist_to_ingal '+!stime
  printf,11,'=================================================='
  printf,11,'# IMAGE and GALFIT CONTROL PARAMETERS'
  printf,11,'A) '+data_fits +'          # Input data image (FITS file)'
  printf,11,'B) '+IDE+'.fits            # Output data image block'
  printf,11,'C) '+sigma_fits+'          # Sigma image name (made from data if blank or "none")'
  printf,11,'D) '+psf_fits  +'          # PSF image name '
  printf,11,'E) 1                       # PSF fine sampling factor relative to data' 
  printf,11,'F) '+mask_fits+'           # Bad pixel mask (FITS image or ASCII coord list)'
  printf,11,'G) none                    # File with parameter constraints (ASCII file)'
  printf,11,'H)'+sregion+'              # Image region to fit (xmin xmax ymin ymax)'
  printf,11,'I) 50    50                # Size of the convolution box (x y)'
  printf,11,'J) 21.0967                   # Magnitude photometric zeropoint '
  printf,11,'K) 0.75     0.75           # Plate scale (dx dy)   [arcsec per pixel]'
  printf,11,'O) regular                 # Display type (regular, curses, both)'
  printf,11,'P) 0                       # Choose: 0=optimize, 1=model, 2=imgblock, 3=subcomps'
 ;printf,11,'S) 0                       # Modify/create objects interactively?'
  printf,11,''



;bulge model
;use totflux=0.25*total flux
;use 0.5*reff of the whole galaxy


  comp_num=1
  i1='(i1)'

  smagbulge=string(magtot+1,f3)
  sreff=string(reff*.5,f3)

  printf,11,'#---------------------------------------------------------------'
  printf,11,'# STRUCTURE:  BULGE'
  printf,11,'# Sersic function'
  printf,11,'# Component number: '+string(comp_num,i1)
  printf,11,' 0) sersic                  #  Component type'
  printf,11,' 1) '+xcs+ycs+'   0 0       #  Position x, y'
  printf,11,' 3) '+smagbulge+'  1        #  Integrated magnitude '
  printf,11,' 4) '+sreff+  '  1          #  R_e (effective radius)   [pix]'
  printf,11,' 5) 2.0          1          #  Sersic index n (de Vaucouleurs n=4)'
  printf,11,' 9) 0.9          1          #  Axis ratio (b/a) '  
  printf,11,' 10) 10.0        1          #  Position angle (PA)  [deg: Up=0, Left=90]'
  printf,11,' Z) 0                       #  leave in [1] or subtract [0] this comp from data?'


  comp_num=2
;disk model

  if(keyword_set(disk)) then begin
     smagdisk=string(magtot+1.,f3)
     srexpo=' 100.'
     sba=string(disk(0))
     spa=string(disk(1))

     sfree='0'
     if(n_elements(disk ge 3)) then begin
        sfree=string(disk(2),'(i1)')
     endif


     printf,11,'#---------------------------------------------------------------'
     printf,11,'# STRUCTURE:  DISK'
     printf,11,'# Exponential function'
     printf,11,'# Component number: '+string(comp_num,i1)
     printf,11,' 0) expdisk              #  Component type'
     printf,11,' 1)'+xcs+ycs+'   0 0     #  Position x, y'
     printf,11,' 3)'+smagdisk+'  1       #  Integrated magnitude '
     printf,11,' 4)' +srexpo+ '  1       #  R_s (disk scale-length)   [pix]'
     printf,11,' 9)' +sba+' '+sfree+'    #  Axis ratio (b/a) '  
     printf,11,'10)' +spa+' '+sfree+'    #  Position angle (PA) [deg: Up=0, Left=90]'
     printf,11,' Z) 0                    #  leave in [1] or subtract [0] this comp from data?'
     comp_num=comp_num+1
  endif

;zdisk = edge-on disk

  if(keyword_set(zdisk)) then begin
     smudisk=string(mu_central+3,f3)
     srexpo=' 50.'
     shz=' 10 '
     spa=' '+string(zdisk,f3)
     printf,11,'#---------------------------------------------------------------'
     printf,11,'# STRUCTURE:  ZDISK'
     printf,11,'# Exponential function'
     printf,11,'# Component number: ' +string(comp_num,i1)
     printf,11,' 0) edgedisk             #  Component type'
     printf,11,' 1)'+xcs+ycs+'   0 0     #  Position x, y  '
     printf,11,' 3)'+smudisk+'   1       #  Mu(0)   [mag/arcsec^2]'
     printf,11,' 4)'+shz+    '   1       #  h_s (disk scale-height)   [pix]'
     printf,11,' 5)'+srexpo+ '   1       #  R_s (disk scale-length)   [pix]'
     printf,11,'10)'+spa+    '   1       #  position angle (PA)  [deg: Up=0, Left=90]'
     printf,11,' Z) 0                    #  leave in [1] or subtract [0] this comp from data?'
     comp_num=comp_num+1
  endif


  if(keyword_set(bar)) then begin
;     smubar=string(mu_central+2,f3)
     smubar=string(mu_reff+2,f3)
     abar=' 50.'
     alpha=' 2 '
     if(keyword_set(disk)) then spa=string(disk(1)+90.)
     if(keyword_set(zdisk)) then spa=string(zdisk(0)+90.)
     printf,11,'#---------------------------------------------------------------'
     printf,11,'# STRUCTURE:  BAR'
     printf,11,'# Ferrer-bar'
     printf,11,'# Component number: '+string(comp_num,i1)
     printf,11,' 0) ferrer2               #  Component type'
     printf,11,' 1)'+xcs+ycs+'  0 0      #  Position x, y '
     printf,11,' 3)'+smubar +'  1        #  surface brghtness at effective radius [mag/arcsec^2]'
     printf,11,' 4)'+abar+   '  1        #  Outer truncation radius  [pix]'
     printf,11,' 5)'+alpha+  '  0        #  Alpha (outer truncation sharpness)' 
     printf,11,' 6)  0          0        #  Beta (central slope)'
     printf,11,' 9   0.5        1        #  Axis ratio (b/a)'
     printf,11,'10)'+spa+    '  1        #  Position angle (PA) [deg: Up=0, Left=90]'
     printf,11,' Z)  0                   #  leave in [1] or subtract [0] this comp from data?'
     comp_num=comp_num+1
  endif


  if(keyword_set(nuc)) then begin
     smagnuc=string(magtot+5,f3)
     printf,11,'#---------------------------------------------------------------'
     printf,11,'# STRUCTURE:  NUCLEUS'
     printf,11,'# point source'
     printf,11,'# Component number: '+string(comp_num,i1)
     printf,11,' 0) psf                  # Object type'
     printf,11,' 1)'+xcs+ycs+'   0 0     # Position x, y '
     printf,11,' 3)'+smagnuc+'   1       # Integrated magnitude' 
     printf,11,' Z) 0                    # leave in [1] or subtract [0] this comp from data?'
     comp_num=comp_num+1
  endif




  close,11





end
