;oppo_tilt.pro
;contains plots of EXAMPLE.readme in a concise form
;assumes that runs oppotest1 oppotest2 oppotest3 tilttest1 tilttest2 
;have been performed

mc_wread_f,'oppotest1'  ; 0.20-5m B=6
mc_wread_f,'oppotest2'  ; 0.20-5m B=26
mc_wread_f,'oppotest3'  ; 0.50-5m B=6


;*****************************************************
;OPPOSTION CURVE
;*****************************************************

!p.multi=[0,2,1]
 nwin

restore,'oppotest2.outwsave'
 alb=0.5
 testa=testm(*,0)*0.
 for i=0,8 do begin & testa=testa+alb^(i+1.)*testm(*,i) & endfor
 testa=testa*iperf
 plot,alpha*!radeg,testa,xtitle='phase-angle',ytitle='I/F',title='0.20-5 m, B=6 and 26 degrees'

 restore,'oppotest1.outwsave'
 alb=0.5
 testa=testm(*,0)*0.
 for i=0,8 do begin & testa=testa+alb^(i+1.)*testm(*,i) & endfor
 testa=testa*iperf
 oplot,alpha*!radeg,testa,col=2

xyouts,4,0.38,'B=26'
xyouts,4,0.20,'B=6'



restore,'oppotest2.outwsave'
 alb=0.5
 testa=testm(*,0)*0.
 for i=0,8 do begin & testa=testa+alb^(i+1.)*testm(*,i) & endfor
 testa=testa*iperf
 plot,alpha*!radeg,testa,xtitle='phase-angle',ytitle='I/F',title='B=6 degrees 0.20-5 m and 0.5 to 5 meters'

 restore,'oppotest3.outwsave'
 alb=0.5
 testa=testm(*,0)*0.
 for i=0,8 do begin & testa=testa+alb^(i+1.)*testm(*,i) & endfor
 testa=testa*iperf
 oplot,alpha*!radeg,testa,col=2

xyouts,4,0.30,'0.50 - 5 m'
xyouts,4,0.20,'0.20 - 5 m'
!p.multi=0


;*****************************************************
;TILT CURVE
;*****************************************************

 nwin
mc_tiltread_f,'tilttest1'   ; 0.20 to 5m
mc_tiltread_f,'tilttest2'   ; 0.50 to 5m

 restore,'tilttest1.tiltsave'
 alb=0.5
 testm=reform(testm_tab(*,0,*))
 testa=testm*0.
 for i=0,8 do begin & testa=testa+alb^(i+1.)*testm(*,i) & endfor
 plot,sunlat_tab,testa,xtitle="B=B'",ytitle='I/F for A=0.5',title='SMIN=0.2 and 0.5'

restore,'tilttest2.tiltsave'
 alb=0.5
 testm=reform(testm_tab(*,0,*))
 testa=testm*0.
 for i=0,8 do begin & testa=testa+alb^(i+1.)*testm(*,i) & endfor
 oplot,sunlat_tab,testa,col=2

xyouts,4,0.40,'0.50 - 5 m'
xyouts,4,0.30,'0.20 - 5 m'

end
