;**********************************
pro mc_wread_f,jobide,plot=plot,nosave=nosave,$
restorefile=restorefile,yrmax0=yrmax0,tau0=tau0,$
print0=print0,xrmax0=xrmax0,enhanced=enhanced
;**********************************

if(n_params() le 0) then begin
print,' mc_wread_f,jobide,plot=plot,nosave=nosave'
print,' restorefile=restorefile,yrmax0=yrmax0'
print,' this procedure is used for reading both opposition-effect'
print,' tilt-effect runs'
return
endif

yrmax=1.
if(keyword_set(yrmax0)) then yrmax=yrmax0

xrmax=0.
if(keyword_set(xrmax0)) then xrmax=xrmax0

outfile=jobide+'.www'
savefile=jobide+'.outwsave'

iprint=0
if(keyword_set(print0)) then iprint=print0


if(not keyword_set(restorefile)) then begin
;print,'outfile'
;read,outfile
close,1
openr,1,outfile
posfile=''

nphot=0l
maxscat=0l
nbox=0l
nboxvis=0l
idum=0l

readf,1,versio
readf,1,posfile
readf,1,sunfii,sunlat,nphot
readf,1,ssca,maxscat,nbox,nboxvis,idum
if(iprint ge 0) then begin
print,'maxscat,nbox,nboxvis,idum'
print,maxscat,nbox,nboxvis,idum
endif
if(versio ge 1) then readf,1,method

ppar1=-999.
ppar2=-999.
ppar3=-999.
if(versio ge 5) then readf,1,ppar1,ppar2,ppar3

readf,1,ntest
if(iprint ge 0) then begin
if(versio ge 3) then begin
if(versio eq 3) then print,'mc_test3: testd corrected, also testd_corr'
if(versio eq 4) then print,'SEP2000: testd corrected, also testd_corr'
if(versio eq 5) then print,'JAN2001'
print,'Nphot=',nphot
endif
endif

no_indir=0
ntest_orig=ntest
if(ntest eq 0) then no_indir=1
if(ntest eq 0) then ntest=1
testfii=fltarr(ntest)
testlat=testfii
testw=testfii
testn=testfii
testd=testfii
testm=fltarr(ntest,10)
testd_corr=testfii
ntest=ntest_orig
if(ntest ne 0) then begin
readf,1,testfii
readf,1,testlat
readf,1,testw
readf,1,testn
readf,1,testd
if(versio ge 3) then readf,1,testd_corr
readf,1,testm
endif


readf,1,iscat_mean,npot_mean,nbox_mean
readf,1,npartori,npart,mx,my
if(iprint ge 0) then begin
print,'iscat_mean,npot_mean,nbox_mean'
print,iscat_mean,npot_mean,nbox_mean
endif

if(versio ge 2) then begin
readf,1,sredu,zredu,tau
readf,1,fdirect,tau_path,tau_n
readf,1,cpu,cpu_comp
endif
sizemin=0
s20=0.
f20=0.
if(versio ge 4) then begin
readf,1,sizemin,s20,f20
endif


close,1
endif;no restore

if(keyword_set(restorefile)) then begin
resfile=restorefile
if(resfile eq 'def') then resfile=jobide+'.outwsave'
restore,resfile
print,'restored from:',resfile
endif

if(iprint ge 0) then begin
print,'sredu,zredu,tau'
print,sredu,zredu,tau
print,'fdirect,tau_path,tau_n'
print,fdirect,tau_path,tau_n
print,'cpu,cpu_comp'
print,cpu,cpu_comp
endif

;INDIRECT METHOD
;normalize to I/F
bsun=sunlat
bobs=testlat
ind=where(bobs eq 0,count)
if(count ge 1) then bobs(ind)=0.01
iperf=abs(sin(sunlat/!radeg)/nphot/sin(testlat/!radeg))  ;different for each bobs

;I/F=iperf*testw
;d(I/F)=iperf*testd    but this error estimate is questionable!
;d(I/F)=iperf*testd_corr   correct error?

if_test=iperf*testw
dif_test=iperf*testd_corr
if_ss_test=iperf*testm(*,0)

;this is valid only after 17.05.01
dif_ss_test=iperf*testd

;***************************************************************
;theoretical ss-flux

ar=1./!radeg
ar=!dpi/180.d0

mu0=sin(bsun*ar)
mu=sin(bobs*ar)
dlobs=sunfii-testfii
if(iprint ge 1) then begin
print,'THEORETICAL SS-flux'
print,'bsun,mu0',bsun,mu0
print,'bobs',bobs
print,'mu',mu
print,'dfii',dlobs
endif

cos_alpha=cos(dlobs*ar)*cos(bsun*ar)*cos(bobs*ar)+sin(ar*bobs)*sin(bsun*ar)
alpha=acos(cos_alpha)

phasef=0.
if(method eq 2) then phasef=1./4./!pi

if(method eq 1 or method eq 11 or method eq 12) then begin
    if(iprint eq 1) then    print,'LAMBERT',method
    s=!pi-alpha
    cosa=cos(s)
    sina=sin(s)
    vak=1./!pi^2/3.*2.
    phasef=vak*(sina-s*cosa)
endif

if(method eq 3 or method eq 4) then begin
    g=ppar1
    if(iprint eq 1) then print,'HG',method,g
    cosa=cos(!pi-alpha)
    phasef=1./4./!pi*(1.-g^2)/(1.-2*g*cosa+g^2)^(1.5)
endif

if(method eq 7 or method eq 8) then begin
    if(iprint eq 1) then print,'CALLISTO',method
    s=!pi-alpha
    phasef=0.153*s^3.092/4./!pi
endif
tau_use=tau
if(not keyword_set(tau0)) then tau_path=tau_n*(1./mu+1./mu0)
if(    keyword_set(tau0)) then begin
tau_use=tau0
print,'tau_n taken as ',tau0
tau_path=tau0*(1./mu+1./mu0)
print,'-> tau_path=',tau_path
endif
ss_theory=mu0*phasef*(1.-exp(-tau_path))/4./(mu0+mu)*4*!pi

indneg=where(mu le 0,countneg)
if(countneg ge 1) then begin
amu=abs(mu(indneg))
ss_theory(indneg)=mu0*phasef(indneg)*(exp(-tau_use/amu)-exp(-tau_use/mu0))/4./(amu-mu0)*4*!pi
endif
if(iprint eq 1) then begin
print,'alpha',alpha/ar
print,'phasef',phasef
print,'ss_theory',ss_theory
print,'ss-indirect',if_ss_test
endif

if(keyword_set(plot)) then begin
nwin
!p.multi=[0,2,1]

plot,testlat,iperf*testw,xtitle='lat',ytitle='I/F',title=savefile,yr=[0,yrmax],ys=1,xr=[0,xrmax]
oplot,testlat,iperf*testm(*,0)
oplot,testlat,ss_theory,lines=2,col=2

plot,testfii,iperf*testw,xtitle='fii',ytitle='I/F',yr=[0,yrmax],ys=1,xr=[0,xrmax]
oplot,testfii,iperf*testm(*,0)
oplot,testfii,ss_theory,lines=2,col=2
xyouts,0.01,0.01,/normal,'mc_wread_f.pro '+!stime,chars=.6
!p.multi=0
endif

if(keyword_set(enhanced)) then begin
if(enhanced eq 1) then begin
nwin
plot,testlat,iperf*testm(*,0)/ss_theory,xtitle='elevation B',ytitle='SS/SS-THEORY'
endif
if(enhanced gt 1) then oplot,testlat,iperf*testm(*,0)/ss_theory,col=enhanced
endif

;****************************************************************


if(not keyword_set(restorefile)) then begin
if(not keyword_set(nosave)) then begin
save,file=savefile,testlat,testfii,testw,testd,testm,testd_corr,versio,posfile,jobide,sunfii,sunlat,nphot,ssca,maxscat,nbox,nboxvis,idum,method,ntest,testn,iscat_mean,npot_mean,nbox_mean,npartori,npart,mx,my,sredu,zredu,tau,fdirect,tau_path,tau_n,cpu,cpu_comp,iperf,iperf,ppar1,ppar2,ppar3,ss_theory,alpha,if_ss_test
print,'saved to ',savefile
endif
endif


end




















